
-- change the default values for these fields to smaller numbers to avoid
-- collisions between temporary field IDs
ALTER TABLE SystemConfiguration
    CHANGE TitleField  TitleField INT DEFAULT -2147483647,
    CHANGE DescriptionField  DescriptionField INT DEFAULT -2147483647,
    CHANGE UrlField  UrlField INT DEFAULT -2147483647,
    CHANGE FileField  FileField INT DEFAULT -2147483647,
    CHANGE ScreenshotField  ScreenshotField INT DEFAULT -2147483647;

UPDATE MetadataFields SET FieldName='Is Part Of' WHERE FieldName='Is Part Of ';

ALTER TABLE MetadataFields ADD COLUMN AllowHTML INT DEFAULT 0;
UPDATE MetadataFields SET AllowHTML = 1;

-- list of search word stems
CREATE TABLE IF NOT EXISTS SearchStems (
    WordId          INT NOT NULL AUTO_INCREMENT,
    WordText        TEXT,
    INDEX           (WordText(16)),
    INDEX           (WordId)
);

ALTER TABLE RSSConfiguration DROP ImageTitle, DROP ImageLink;

-- RSS feed cache. skip Type and Charset because the next query will add them
-- if the table did not exist or already existed
CREATE TABLE IF NOT EXISTS RSSClientCache (
    ServerUrl      TEXT,
    CachedXml      TEXT,
--    Type           TEXT,
--    Charset        TEXT,
    LastQueryTime  DATETIME
);

-- new fields to help with encoding
ALTER TABLE RSSClientCache
ADD Type TEXT AFTER CachedXml,
ADD Charset TEXT AFTER Type;

-- cached XML should be flushed so that the new field values can be fetched
TRUNCATE TABLE RSSClientCache;

-- add new system configuration field
ALTER TABLE SystemConfiguration
ADD DefaultRecordsPerPage INT DEFAULT 5
AFTER DefaultCharacterSet;

-- change so that a default is not set and can be set programmatically
ALTER TABLE APUsers ALTER COLUMN RecordsPerPage DROP DEFAULT;

-- fix typo in the system configuration table if it was created in >= 2.1.1
-- if it was created before then and upgraded, it will be correct
ALTER TABLE SystemConfiguration CHANGE COLUMN PreferredLinKValue PreferredLinkValue ENUM ("URL", "FILE") DEFAULT "FILE";
