<?PHP

class AddThis_Button
{

    /**
     * @const STYLE_* built-in AddThis class names for styling purposes
     */
    const STYLE_DEFAULT = "addthis_button";
    const STYLE_EMAIL = "addthis_button_email";
    const STYLE_FACEBOOK_LIKE = "addthis_button_facebook_like";
    const STYLE_TWEET = "addthis_button_tweet";
    const STYLE_TWEETMEME = "addthis_button_tweetmeme";
    const STYLE_COUNTER = "addthis_counter";
    const STYLE_COMPACT = "addthis_button_compact";
    const STYLE_EXPANDED = "addthis_button_expanded";

    /**
     * Set the class name of the button.
     * @param $Class class name
     */
    public function SetClass($Class)
    {
        $this->Class = defaulthtmlentities($Class);
    }

    /**
     * Add an HTML attribute for the button. Does not allow setting the class
     * name attribute, see self::SetClass for that.
     * @param $Name HTML attribute name
     * @param $Value HTML attribute value
     */
    public function AddHtmlAttribute($Name, $Value)
    {
        $NormalizedName = strtolower($Name);

        if ($NormalizedName != "class")
        {
            $this->Attributes[$NormalizedName] = $Value;
        }
    }

    /**
     * Set the inner content of the button.
     * @param $InnerHtml HTML content
     */
    public function SetInnerHtml($InnerHtml)
    {
        $this->InnerHtml = $InnerHtml;
    }

    /**
     * Generate and return the HTML representation of the button.
     * @return the HTML representation of the button
     */
    public function GetHtml()
    {
        $Class = $this->Class;
        $Attributes = $this->Attributes;
        $InnerHtml = $this->InnerHtml;

        $Html = "<a class=\"".$Class."\"";

        foreach ($Attributes as $Name => $Value)
        {
            $EscapedValue = defaulthtmlentities($Value);
            $Html .= " ".$Name."=\"".$EscapedValue."\"";
        }

        $Html .= ">";

        if (!is_null($InnerHtml))
        {
            $Html .= $InnerHtml;
        }

        $Html .= "</a>";

        return $Html;
    }

    /**
     * Generate and print the HTML representation of the button.
     */
    public function PrintHtml()
    {
        print $this->GetHtml();
    }

    /**
     * @var $Class button class name, with self::STYLE_DEFAULT as the default
     * @var $Attributes array of HTML attributes
     * @var $InnerHtml inner HTML content
     */
    private $Class = self::STYLE_DEFAULT;
    private $Attributes = array();
    private $InnerHtml;

}
