<?php

#
#   FILE:  SPT--PurgeSampleDataExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

PageTitle("Purge Sample Data");
$DB = new SPTDatabase();

# check for cancel button
if ($_POST["Submit"] == "Cancel")
{
    $AF->SetJumpToPage("index.php?P=SysAdmin");
    return;
}

# dump out all necessary fields for all records 
$RFactory = new ResourceFactory();
$ResourceList = $RFactory->GetItemIds("INSTR(Description, '[--SAMPLE RECORD--]') > 0 OR INSTR(Description, '[SCOUT PORTAL TOOLKIT SAMPLE RECORD]') > 0");

$ResourceCount = 0;
$ClassIds = array();
$CNIds = array();

foreach ($ResourceList as $ResourceId)
{
    $Resource = new Resource($ResourceId);

    # get Classifications associated with this Resource
    $Names = $Resource->Classifications();
    foreach ($Names as $ClassificationType => $ClassificationTypes)    
    {
        foreach ($ClassificationTypes as $ClassId => $Classification)
        {
            $ClassIds[$ClassId] = $Classification;
        }
    }

    # get ControlledNames associated with this Resource
    $Creators = $Resource->Get("Creator");
    foreach ($Creators as $CNId => $Creator)
    {
        $CNIds[$CNId] = $Creator;
    }
    $Publishers = $Resource->Get("Publisher");
    foreach ($Publishers as $CNId => $Publisher)
    {
        $CNIds[$CNId] = $Publisher;
    }
  
    $Resource->Delete();
    $ResourceCount++;
}

# post-process classification ids
$ClassificationCount = 0;
foreach ($ClassIds as $ClassId => $Classification)
{
    $Class = new Classification($ClassId);
    if ($Class->Status() == Classification::CLASSSTAT_OK)
    {
        # delete classification and parents if no other resources assigned
        $Class->Delete(TRUE);
        $ClassificationCount++;
    }
}

# post-process controlledname ids
$ControlledNameCount = 0;
foreach ($CNIds as $CNId => $Dummy)
{
    # see if any resources are still using this controlled name
    $CN = new ControlledName($CNId);

    # controlled name not in use, so delete it  
    if (!$CN->InUse())
    {
        $CN->Delete();
        $ControlledNameCount++;
    }
}

$Session->PassVariable("ResourceCount", $ResourceCount);
$Session->PassVariable("ClassificationCount", $ClassificationCount);
$Session->PassVariable("ControlledNameCount", $ControlledNameCount);


?>
