<?php
#
#   FILE:  SPT--PreviewMessage.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintHeading()
{
    global $Message;

    if ($Message)
        print "Preview Message";
    else
        print "Preview Topic and Message";
}

function PrintSubmitButton()
{
    global $Message;

    if ($Message)
        print "Post New Message";
    else
        print "Add New Topic and Message";

}

function PrintEditButton()
{
    global $Message;

    if ($Message)
        print "Edit Message";
    else
        print "Edit Topic and Message";

}

function PrintForumId()
{
    global $F_ForumId;

    print $F_ForumId;
}

function PrintParentId()
{
    global $Session;

    $ParentId = $Session->Get("ParentId");

    print $ParentId;
}

function PrintForumName()
{
    global $ForumName;

    print StripXSSThreats(stripslashes($ForumName));
}

function PrintTopic()
{
    global $F_TopicName;

    print StripXSSThreats(stripslashes($F_TopicName));
}

function PrintBody()
{
    global $F_Body;

    print StripXSSThreats(stripslashes($F_Body));
}

function PrintSubject()
{
    global $F_Subject;

    print StripXSSThreats(stripslashes($F_Subject));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_Body;
global $F_ForumId;
global $F_Subject;
global $F_TopicName;
global $ForumName;
global $Message;

if ($Session->IsRegistered("ForumId"))
    $F_ForumId = $Session->Get("ForumId");

if (isset($F_ForumId))
    $Forum = new Forum($F_ForumId);

$ForumName = $Forum->ForumName();
$ModeratorId = $Forum->ModeratorId();

if ($Session->IsRegistered("Message"))
    $Message = $Session->Get("Message");
if ($Session->IsRegistered("ParentId"))
    $ParentId = $Session->Get("ParentId");
if ($Session->IsRegistered("F_Subject"))
    $F_Subject = $Session->Get("F_Subject");
if ($Session->IsRegistered("F_Body"))
    $F_Body = $Session->Get("F_Body");
if ($Session->IsRegistered("F_TopicName"))
    $F_TopicName = $Session->Get("F_TopicName");

#if (!empty($_GET["messageid"]))
#{
#    $MessageId = $_GET["messageid"];
#    $Message = new Message($MessageId);
#    $Subject = $Message->Subject();
#    $Body = $Message->Body();
#    $PosterId = $Message->PosterId();
#}

$Session->PassVariable("Message", $Message);
$Session->PassVariable("ForumId", $F_ForumId);
$Session->PassVariable("F_Subject", $F_Subject);
$Session->PassVariable("F_Body", $F_Body);
$Session->PassVariable("F_TopicName", $F_TopicName);
if (isset($ParentId))
  $Session->PassVariable("ParentId", $ParentId);

PageTitle("Preview Message");

?>
