<?php

#
#   FILE:  SPT--Preferences.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessages()
#           - print any outstanding error messages from form processing
#       PrintActiveUIOptionList()
#           - print option list containing user interfaces, current UI selected 
#       PrintCurrentRealName()
#       PrintCurrentEMail()
#       PrintCurrentWebSite()
#       PrintCurrentAddressLineOne()
#       PrintCurrentAddressLineTwo() 
#       PrintCurrentCity()
#       PrintCurrentState()
#       PrintCurrentZipCode()
#       PrintCurrentCountry()
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("User Preferences");

function PrintErrorMessages()
{
    global $ErrorMessages;
    global $Session;

    # if error messages were passed from PreferencesComplete
    if (isset($ErrorMessages) && is_array($ErrorMessages) &&
        count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

function PrintActiveUIOptionList()
{
    global $User;

    # print option list for UI
    print(GetActiveUIOptionList($User->Get("ActiveUI")));
}

function PrintCurrentRealName()
{
    global $User;
    print($User->Get("RealName"));
}

function PrintCurrentEMail()
{  
    global $User;  
    print($User->Get("EMail"));
}

function PrintCurrentWebSite()
{
    global $User;
    print($User->Get("WebSite"));
}

function PrintCurrentAddressLineOne()
{
    global $User;
    print($User->Get("AddressLineOne"));
}

function PrintCurrentAddressLineTwo() 
{
    global $User;
    print($User->Get("AddressLineTwo"));
}

function PrintCurrentCity()
{
    global $User;
    print($User->Get("City"));
}

function PrintCurrentState()
{
    global $User;
    print($User->Get("State"));
}

function PrintCurrentZipCode()
{
    global $User;
    print($User->Get("ZipCode"));
}

function PrintCurrentCountry()
{
    global $User;
    print($User->Get("Country"));
}

# non-standard global variables
global $ErrorMessages;

if ($Session->IsRegistered("ErrorMessages"))
    $ErrorMessages = $Session->Get("ErrorMessages");

# check if user is logged in
if ($User->IsLoggedIn() == FALSE) 
{  
    $AF->SetJumpToPage("Home");
}

?>
