<?PHP

#
#   FILE:  SPT--DBOrderFieldsComplete.php
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# Moves a single $FieldId $NumMoves positions 
function MoveField( $Schema, $FieldId, $NumMoves, $OrderType )
{

	global $Schema;
	
	# Move fields Up if value is positive
	if ( $NumMoves > 0 )
	{
		for( $i = $NumMoves ; $i > 0 ; $i-- )
		{
			$Schema->MoveUpInOrder( $FieldId, $OrderType );
		}
	}

	# Move fields Down if value is Negative
	else if ( $NumMoves < 0 )
	{
		for( $j = $NumMoves; $j < 0 ; $j++ )
		{
			$Schema->MoveDownInOrder( $FieldId, $OrderType );
		}
	}
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Schema;

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

# If Javascript is working properly, "Submit" will be the only
# active submit button. Act accordingly
if ($_POST["Submit"] == "Submit")
{
    $Schema = new MetadataSchema();

    # Parse the moves
    $Moves = explode("\n", $_POST["FieldMoves"]);
    
    foreach ( $Moves as $move )
    {
    	$MoveChunks = explode("*", $move);
    	
    	# Handle each move with a call to MoveField
    	if ( $MoveChunks[0] == "Display" )
    		MoveField( $Schema, $MoveChunks[1], (int) $MoveChunks[2],
    		    MetadataSchema::MDFORDER_DISPLAY );

    	else if ( $MoveChunks[0] == "Edit" )
    		MoveField( $Schema, $MoveChunks[1], (int) $MoveChunks[2],
    		    MetadataSchema::MDFORDER_EDITING );
    }
    
    # return to Field Ordering screen 
    $AF->SetJumpToPage("DBOrderFields");
}

# If javascript isn't working properly, one of these cases will occur
else if ( $_POST["Submit"] == "DisplayUp" )
{
    #Perform a single Move Up on the given field value
    $Schema = new MetadataSchema();
    $Schema->MoveUpInOrder( $_POST["DisplayFields"], MetadataSchema::MDFORDER_DISPLAY);
    
    # return to Field Ordering screen 
    $AF->SetJumpToPage("DBOrderFields");
}
else if ( $_POST["Submit"] == "DisplayDown" )
{
    #Perform a single Move Down on the given field value
    $Schema = new MetadataSchema();
    $Schema->MoveDownInOrder( $_POST["DisplayFields"], MetadataSchema::MDFORDER_DISPLAY);

    # return to Field Ordering screen 
    $AF->SetJumpToPage("DBOrderFields");

}
else if ( $_POST["Submit"] == "EditingUp" )
{
    #Perform a single Move Up on the given field value
    $Schema = new MetadataSchema();
    $Schema->MoveUpInOrder( $_POST["DisplayFields"], MetadataSchema::MDFORDER_EDITING);

    # return to Field Ordering screen 
    $AF->SetJumpToPage("DBOrderFields");

}
else if ( $_POST["Submit"] == "EditingDown" )
{
    #Perform a single Move Up on the given field value
    $Schema = new MetadataSchema();
    $Schema->MoveDownInOrder( $_POST["DisplayFields"], MetadataSchema::MDFORDER_EDITING);

    # return to Field Ordering screen 
    $AF->SetJumpToPage("DBOrderFields");
    
}

# Get our of here if anything else was hit
else
{
    # return to SysAdmin menu 
    $AF->SetJumpToPage("SysAdmin");
}

?>
