<?PHP
#
#   FILE:  ConfirmReport.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   Copyright 2010 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Version-agnostic htmlentities() function.
 * See: http://www.php.net/manual/en/function.htmlentities.php
 * @param $string the input string
 * @param $quote_style defines what is done with quotes
 * @param $charset defines the character set used in conversion
 * @param $double_encode when off, PHP won't encode existing HTML entities (>= 5.2.3)
 * @return the encoded string
 */
function safehtmlentities($string, $quote_style=ENT_COMPAT, $charset="ISO-8859-1", $double_encode=TRUE)
{
    # get php's version
    list($Major, $Minor, $Maint) = explode(".", phpversion());
    $Major = intval($Major);
    $Minor = intval($Minor);
    $Maint = intval($Maint);

    # ignore $double_encode param if php version < 5.2.3
    if ($Major < 5 || $Major < 6 && $Minor < 2 || $Major < 6 && $Minor < 3 && $Maint < 4)
    {
        return htmlentities($string, $quote_style, $charset);
    }

    return htmlentities($string, $quote_style, $charset, $double_encode);
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Confirm reporting an URL");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ResourceId = isset($_GET["ResourceId"]) ? intval($_GET["ResourceId"]) : NULL;
$FieldId = isset($_GET["FieldId"]) ? intval($_GET["FieldId"]) : NULL;
$Resource = new Resource($ResourceId);
$Schema = new MetadataSchema();
$Field = $Schema->GetField($FieldId);
$TitleField = $Schema->GetFieldByMappedName("Title");

if ($Resource->Status() == 1 && $Field->Status() == MetadataSchema::MDFSTAT_OK)
{
    $InvalidUrl = $AF->SignalEvent("URLCHECKER_GET_INVALID_URL", array($Resource, $Field));
    $Info = $AF->SignalEvent("URLCHECKER_GET_INFORMATION");
}

else
{
    $AF->SuppressHTMLOutput();
    $AF->SetJumpToPage("index.php?P=P_UrlChecker_Results");
}

?>
