<?PHP

#
#   FILE:  SPT--EditRSSImportComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   FORM FIELDS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

@$F_Title = $_POST["F_Title"];
@$F_URL = $_POST["F_URL"];
@$F_NumberItemsToDisplay = $_POST["F_NumberItemsToDisplay"];
@$F_Enabled = $_POST["F_Enabled"];

$DispVal = 0;
if ( isset($_POST['F_DisplayLocations']) )
{
    foreach ($_POST['F_DisplayLocations'] as $DispLoc)
    {
        $DispVal = $DispVal | $DispLoc;
    }

}
$F_DisplayLocations = $DispVal;
@$F_RefreshRate = $_POST["F_RefreshRate"];
@$F_RSSId = $_POST["F_RSSId"];

$ErrorMessages = new ErrorList();

$TriggerSaveChanges = false;        //Flag for save changes clause

// If not requesting to edit/delete a feed, verify input values
// Since those two actions are the only ones to submit the $F_RSSId variable,
// that can be the flag
if ( !isset($F_RSSId) )
{
    if (!isset($F_Title) || !strlen($F_Title))
        $ErrorMessages->AddMessage("An RSS feed must have a title");

    if(!isset($F_URL) || !strlen($F_URL))
        $ErrorMessages->AddMessage("An RSS feed must have a URL");

    if(!isset($F_NumberItemsToDisplay) || $F_NumberItemsToDisplay<1)
        $ErrorMessages->AddMessage("Items to display must be a positive number");

    if ($ErrorMessages->HasErrors())
    {
        $Session->PassVariable("ErrorMessages");
        $AF->SetJumpToPage("EditRSSImport");
        return;
    }
}
elseif ( !@isset($_POST['Submit']) )
//RSSId exists, but no submit command, so we're in Enabled/Disabled case
{
    $DB = new SPTDatabase();

    // Get information to save back into DB w/ new enabled state
    $Query = "SELECT * FROM RSSFeeds WHERE RSSId=$F_RSSId LIMIT 1";
    $DB->Query($Query);

    while ($Row = $DB->FetchRow())
    {
        $F_Title = stripslashes($Row['Title']);
        $F_URL = stripslashes($Row['URL']);
        $F_NumberItemsToDisplay = stripslashes($Row['NumberItemsToDisplay']);
        $F_DisplayLocations = stripslashes($Row['DisplayLocations']);
        $F_RefreshRate = stripslashes($Row['RefreshRate']);
    }

    $TriggerSaveChanges = true;

}

// Perform requested tasks
if (@$_POST['Submit'] == "Add Feed")
{
    $DB = new SPTDatabase();

    // Insert new feed into DB
    $Query = "INSERT INTO RSSFeeds SET Enabled='$F_Enabled'";
    $DB->Query($Query);

    $F_RSSId = $DB->LastInsertId('RSSFeeds');

    //Trigger the Save Changes clause
    $TriggerSaveChanges = true;
}

if ($TriggerSaveChanges || $_POST['Submit'] == "Save Changes")
{
    if (!isset($F_RSSId))
    {
        $F_RSSId = $Session->Get("RSSId");
    }

    // Insert new feed into DB
    $Query = "  UPDATE RSSFeeds
                SET Enabled='".addslashes($F_Enabled)."',
                Title='".addslashes($F_Title)."',
                URL='".addslashes($F_URL)."',
                DisplayLocations='".addslashes($F_DisplayLocations)."',
                NumberItemsToDisplay='".addslashes($F_NumberItemsToDisplay)."',
                RefreshRate='".addslashes($F_RefreshRate)."'
                WHERE RSSId=$F_RSSId
                LIMIT 1";
    $DB->Query($Query);

    $AF->SetJumpToPage("EditRSSImport");
}
elseif ($_POST['Submit'] == "Edit")
{
    $Session->PassVariable("RSSId",$F_RSSId);
    $AF->SetJumpToPage("EditRSSImport");
}
elseif ($_POST['Submit'] == "Delete")
{
    $DB = new SPTDatabase();

    //Delete RSS Feed
    $DB->Query("DELETE FROM RSSFeeds WHERE RSSId='$F_RSSId'");

    $AF->SetJumpToPage("EditRSSImport");
}
else
{
    $AF->SetJumpToPage("EditRSSImport");
}
?>
