<?PHP
#
#   FILE:  LeaveFeedbackComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Collection Workflow Information System
#   Copyright 2007 Internet Scout and Edward Almasy
#   http://scout.wisc.edu
#

PageTitle("Feedback Recorded");

# if user didn't cancel feedback and user was not a bot
if ($_POST["Submit"] != "Cancel" && $_POST["F_Spmbt"] === "2001ASO")
{
    # process user input based on feedback type
    $G_FeedbackType = $_POST["F_FeedbackType"];
    switch ($G_FeedbackType)
    {
        case "ResourceSuggestion":
            $G_MailSubject = "Resource Suggestion (".$_POST["F_Title"].")";
            $G_MailBody = "\nTITLE:\n".trim($_POST["F_Title"])
                    ."\nURL:\n".trim($_POST["F_Url"])
                    ."\n\nDESCRIPTION:\n".trim($_POST["F_Description"]);
            break;

        case "ResourceFeedback":
            $ResourceId = $_POST["F_ResourceId"];
            $G_Resource = new Resource($ResourceId);
            $Schema = new MetadataSchema();
            $UrlBase = OurUrl();
            $G_MailSubject = "Resource Feedback"
                    .($Schema->FieldExists("Title")
                            ? " (".$G_Resource->Get("Title").")" : "");
            $G_MailBody = "\n"
                .($Schema->FieldExists("Title")
                  ? "TITLE: ".$G_Resource->Get("Title")."\n" : "")
                .($Schema->FieldExists("Url")
                  ? "  URL: ".$G_Resource->Get("Url")."\n" : "")
                ." VIEW: ".$UrlBase."?P=FullRecord"
                ."&ResourceId=".$ResourceId."\n"
                ." EDIT: ".$UrlBase."?P=EditResource"
                ."&ID=".$ResourceId."\n"
                ."\nPROBLEM DESCRIPTION:\n".trim($_POST["F_Description"]);
            break;

        case "Feedback":
            $F_Subject = $_POST["F_Subject"];
            $F_Body    = $_POST["F_Body"];
            $G_MailSubject = strlen(trim($F_Subject))
                    ? trim($F_Subject) : "User Feedback";
            $G_MailBody = trim($F_Body);
            break;

        default:
            break;
    }

    # if we have feedback e-mail content to send
    if (isset($G_MailBody) && strlen($G_MailBody))
    {
        # prepend portal name onto message subject
        $G_MailSubject = "[".$SysConfig->PortalName()."] ".$G_MailSubject;

        # append context info onto message body
        $IpAddress = preg_match("/\b(?:[0-9]{1,3}\.){3}[0-9]{1,3}\b/",
                        $_SERVER["REMOTE_ADDR"])
                ? gethostbyaddr($_SERVER["REMOTE_ADDR"])
                : $_SERVER["REMOTE_ADDR"];
        $EmailAddress = $User->IsLoggedIn() ? $User->Get("EMail")
                : ((isset($_POST["F_EmailAddress"])
                        && SPTUser::IsValidLookingEMailAddress($_POST["F_EmailAddress"]))
                ? $_POST["F_EmailAddress"] : "(no e-mail address supplied)");
        $G_MailBody .= "\n\n---"
                ."\nUSER: ".($User->IsLoggedIn() ? $User->Get("UserName") : "(not logged in)")
                ."\nNAME: ".($User->IsLoggedIn() ? $User->Get("RealName") : "(not logged in)")
                ."\nEMAIL: ".$EmailAddress
                ."\nADDRESS: ".$IpAddress
                ."\n";

        # assemble e-mail address for user
        if ($User->IsLoggedIn())
        {
            if (strlen(trim($User->Get("RealName"))))
            {
                $UserEMail = trim($User->Get("RealName"))." <"
                    .$User->Get("EMail").">";
            }
            else
            {
                $UserEMail = trim($User->Get("UserName"))." <"
                    .$User->Get("EMail").">";
            }
        }
        elseif (isset($_POST["F_EmailAddress"])
                && SPTUser::IsValidLookingEMailAddress($_POST["F_EmailAddress"]))
        {
            $UserEMail = $SysConfig->PortalName()." User <".$_POST["F_EmailAddress"].">";
        }
        else
        {
            $UserEMail = "Anonymous ".$SysConfig->PortalName()." User <"
                    .$SysConfig->AdminEmail().">";
        }

        # mail feedback to admin
        $Result = mail($SysConfig->AdminEmail(), $G_MailSubject, $G_MailBody,
                "From: ".$UserEMail."\r\n"
                        ."Reply-To: ".$UserEMail);
    }
}
# else assume Cancel was selected
else
{
    $G_AutoRefreshPage = "?P=Home";
    $G_AutoRefreshTitle = "Home";
}

?>
