<?PHP
#
#   FILE:  SPT--FullImage.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

$FieldName = $_GET["FieldName"];
PageTitle($FieldName." Display");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print field name
function PrintFieldName()
{
    global $FieldName;

    print $FieldName;
}

# print Resource Title
function PrintResourceTitle()
{
    global $ResourceTitle;

    print $ResourceTitle;
}

# print Url
function PrintUrl()
{
    global $Url;

    print $Url;
}

# print Record Link
function PrintRecordLink()
{
    global $RecordLink;

    print $RecordLink;
}

# print Return Page
function PrintReturnPage()
{
    global $ReturnPage;

    print $ReturnPage;
}

# print Height
function PrintHeight()
{
    global $Height;

    print $Height;
}

# print Width
function PrintWidth()
{
    global $Width;

    print $Width;
}

# print AltText
function PrintAltText()
{
    global $AltText;

    print $AltText;
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $AltText;
global $FieldName;
global $Height;
global $RecordLink;
global $ResourceTitle;
global $ReturnPage;
global $Url;
global $Width;

$Resource = new Resource($_GET["ResourceId"]);
$ResourceTitle = $Resource->Get("Title");
$SPTImage = $Resource->Get($_GET["FieldName"], TRUE);
$Width = $SPTImage->Width();
$Height = $SPTImage->Height();
$Url = $SPTImage->Url();
$AltText = $SPTImage->AltText();

# return to metadata tool
if (isset($_GET["edit"]))
{
    $RecordLink = "index.php?P=EditResource&amp;ID=".$Resource->Id();
    $ReturnPage = "Edit Resource for ";
}
# return to full record
else
{
    $RecordLink = "index.php?P=FullRecord&amp;ResourceId=".$Resource->Id();
    $ReturnPage = "Full Record for ";
}

?>
