<?PHP

#
#   FILE:  SPT--PreferencesComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#
global $ErrorMessages;

# check if user is logged in
if ($User->IsLoggedIn() == FALSE) 
{  
    $AF->SetJumpToPage("Home");
}

# if new password was supplied
if ($_POST["Submit"] == "Save New Settings")
{
    if (strlen($_POST["F_NewPassword"]) > 0)
    {
        # attempt to change password
        $Status = $User->ChangePassword(
            $_POST["F_OldPassword"],
            $_POST["F_NewPassword"],
            $_POST["F_NewPasswordAgain"]);

        # if password change was unsuccessful
        if ($Status != U_OKAY)
        {
            # add to error list
            $ErrorMessages[] = $User->StatusMessage();
        }
        else
        {
            # signal password change
            $AF->SignalEvent("EVENT_USER_PASSWORD_CHANGED", array(
                    "UserId" => $User->Id(), 
                    "OldPassword" => $_POST["F_OldPassword"], 
                    "NewPassword" => $_POST["F_NewPassword"]));
        }
    }
    # set new active UI
    else if (isset($_POST["F_ActiveUI"]))
    {
        $User->Set("ActiveUI", $_POST["F_ActiveUI"]);
    }
}
else if ($_POST["Submit"] == "Change User Information")
{

    # if record was found
    if ($User->Status() == U_OKAY)
    {
        # save new user settings
        $User->Set("RealName", isset($_POST["F_RealName"]) ? $_POST["F_RealName"] : "");
        $User->Set("WebSite", isset($_POST["F_WebSite"]) ? $_POST["F_WebSite"] : "");
        $User->Set("AddressLineOne", isset($_POST["F_AddressLineOne"]) ? $_POST["F_AddressLineOne"] : "");
        $User->Set("AddressLineTwo", isset($_POST["F_AddressLineTwo"]) ? $_POST["F_AddressLineTwo"] : "");
        $User->Set("City", isset($_POST["F_City"]) ? $_POST["F_City"] : "");
        $User->Set("State", isset($_POST["F_State"]) ? $_POST["F_State"] : "");
        $User->Set("ZipCode", isset($_POST["F_ZipCode"]) ? $_POST["F_ZipCode"] : "");
        $User->Set("Country", isset($_POST["F_Country"]) ? $_POST["F_Country"] : "");

        if (isset($_POST["F_EMail"]))
        {
            if (User::IsValidLookingEmailAddress($_POST["F_EMail"]))
            {
                $OldEmail = $User->Get("EMail");
                $NewEmail = $_POST["F_EMail"];

                $User->Set("EMail", $NewEmail);
                #Signal the email change
                $AF->SignalEvent("EVENT_USER_EMAIL_CHANGED", array(
                                     "UserId" => $User->Id(),
                                     "OldEmail" => $OldEmail,
                                     "NewEmail" => $NewEmail));

            }
            else
            {
                $ErrorMessages []= "Invalid Email";
            }
        }     
    }
    else
    {
        # put up error message
        $ErrorMessages []= "Your information could not be modified. Please contact the webmaster.";
    }
}

# if errors were found
if (isset($ErrorMessages))
{
    # make error list persistent
    $Session->PassVariable("ErrorMessages");

    # return to editing page
    $AF->SetJumpToPage("Preferences");
}
else
{
    # return to home page
    $AF->SetJumpToPage("Home");
}

?>
