(function(window){
  var basePath = getBasePath(window),
      override = false;

  // if an include path is accessible
  if ("undefined" != typeof CWIS_CKEDITOR_OVERRIDE) {
    override = CWIS_CKEDITOR_OVERRIDE;
  }

  // load the default stylesheets into ckeditor
  if ("undefined" != typeof CKEDITOR) {
    if (override) {
      CKEDITOR.config.contentsCss = [
        basePath + "interface/default/include/CW-Theme.css",
        basePath + override];
    } else {
      CKEDITOR.config.contentsCss = [
        basePath + "interface/default/include/CW-Theme.css"];
    }

    // apply class to the body element of the editor
    CKEDITOR.config.bodyClass = "cw-ckeditor-body";

    // apply class to the html element of the editor (there is no built-in way
    // to accomplish this)
    CKEDITOR.on("instanceReady", function(ev) {
      for (var i in CKEDITOR.instances) {
        CKEDITOR.instances[i].document.$.body.parentNode.className += " cw-ckeditor-html";
      }
    });

    CKEDITOR.config.toolbar = "Abbreviated";

    CKEDITOR.config.toolbar_Abbreviated =
    [
      { name: 'document',   items : [ 'Source' ] },
      { name: 'clipboard',  items : [ 'Undo','Redo' ] },
      { name: 'editing',    items : [ 'Find','Replace' ] },
      { name: 'paragraph2',    items : [ 'JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock' ] },
      { name: 'links',        items : [ 'Link','Unlink' ] },
      { name: 'insert',       items : [ 'HorizontalRule','SpecialChar' ] },
      { name: 'tools',    items : [ 'Maximize', 'ShowBlocks' ] },
      '/',
      { name: 'styles',   items : [ 'Styles','Format' ] },
      { name: 'basicstyles',  items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript','-','RemoveFormat' ] },
      { name: 'paragraph1',    items : [ 'NumberedList','BulletedList','-','Blockquote' ] }
    ];

    CKEDITOR.config.toolbar_Full =
    [
      { name: 'document',   items : [ 'Source','-','Save','DocProps','Preview' ] },
      { name: 'clipboard',  items : [ 'Cut','Copy','Paste','-','Undo','Redo' ] },
      { name: 'editing',    items : [ 'Find','Replace','-','SelectAll','-','SpellChecker', 'Scayt' ] },
      '/',
      { name: 'basicstyles',  items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript','-','RemoveFormat' ] },
      { name: 'paragraph',    items : [ 'NumberedList','BulletedList','-','Blockquote','CreateDiv','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock' ] },
      { name: 'links',        items : [ 'Link','Unlink','Anchor' ] },
      { name: 'insert',       items : [ 'HorizontalRule','SpecialChar' ] },
      '/',
      { name: 'styles',   items : [ 'Styles','Format' ] },
      { name: 'tools',    items : [ 'Maximize', 'ShowBlocks','-','About' ] }
    ];

    // set the formats in the format select box
    CKEDITOR.config.format_tags = 'p;h1;h2;h3;h4;h5;h6;pre;div'

    CKEDITOR.config.stylesSet = [
      { name : 'Computer Code'    , element : 'code' },

      { name : 'Deleted Text'     , element : 'del' },
      { name : 'Inserted Text'    , element : 'ins' },

      { name : 'Cited Work'       , element : 'cite' },
      { name : 'Inline Quotation' , element : 'q' }
    ];
  };

  function getBasePath(window) {
    var path = window.location.pathname;

    // get the path without the file name
    path = path.replace(/\\/g, "/").replace(/\/[^\/]*\/?$/, "");

    // add trailing slash if one isn't there
    if (path.charAt(path.length) != "/") {
      path += "/";
    }

    return path;
  }

}(window));
