<?PHP
#
#   FILE:  TaskQueue.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Task Queue");

# need sysadmin privileges for this page
if (!CheckAuthorization(PRIV_SYSADMIN)) { return; }

# refresh the page every 30 seconds
$PageUrl = OurBaseUrl() . "index.php?P=TaskQueue";
header("Refresh: 30; url=".$PageUrl);

# if action requested
if (isset($_GET["AC"]) && isset($_GET["ID"]))
{
    $Action = $_GET["AC"];
    $TaskId = intval($_GET["ID"]);

    # re-queue orphaned task if requested
    if ($Action == "REQUEUE")
    {
        $AF->ReQueueOrphanedTask($TaskId);
    }

    # remove orphaned task if requested
    else if ($Action == "DELETE")
    {
        $AF->DeleteTask($TaskId);
    }

    # run task in foreground if requested
    else if ($Action == "RUN")
    {
        # retrieve task
        $Task = $AF->GetTask($TaskId);

        # if specified task found
        if ($Task)
        {
            # attempt to load task callback if not already available
            $AF->LoadFunction($Task["Callback"]);

            # if callback appears callable
            if (is_callable($Task["Callback"]))
            {
                # run task
                if ($Task["Parameters"])
                {
                    call_user_func_array($Task["Callback"], $Task["Parameters"]);
                }
                else
                {
                    call_user_func($Task["Callback"]);
                }

                # remove task from queue
                $AF->DeleteTask($TaskId);
            }
        }
    }
}
