<?PHP
#
#   FILE:  EditResource.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/
#

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN))
        {  return;  }

# if resource ID was supplied
$G_AddingNewResource = FALSE;
if (isset($_GET["ID"]) )
{
    # if this is a view request (from editing complete form)
    if (isset($_POST["Submit"]) && ($_POST["Submit"] == "View"))
    {
        # go to full record page
        $AF->SetJumpToPage("FullRecord&ID=".intval($_GET["ID"]));
    }
    else
    {
        # retrieve resource ID (or NULL if adding new resource)
        $ResourceId = isset($_GET["ID"]) ? intval($_GET["ID"]) : NULL ;
        $ResourceId = ($ResourceId == "NEW") ? NULL : intval($ResourceId);

        # load resource to be edited
        $G_Resource = new Resource($ResourceId);

        # if resource failed to load
        if ($G_Resource->Status() != 1)
        {
            # set flag to indicate error message needed
            $G_ResourceNotFound = TRUE;
        }
        else
        {
            # set flag to indicate if we are adding a new resource
            $G_AddingNewResource = $G_Resource->IsTempResource();

            # set page title to indicate adding or editing
            PageTitle($G_AddingNewResource ? "Add Resource" : "Edit Resource");

            # load metadata fields
            $Schema = new MetadataSchema();
            $G_Fields = $Schema->GetFields(NULL, MetadataSchema::MDFORDER_EDITING);

            if (strlen($G_Resource->Get("Date Record Checked")) == 0 )
            {
                $G_Resource->Set("Date Record Checked", date("Y-m-d H:i:s"));
            }

            # Update timestamps as required:
            $TimestampFields = $Schema->GetFields(
                MetadataSchema::MDFTYPE_TIMESTAMP);
            foreach ($TimestampFields as $Field)
            {
                if ($Field->UpdateMethod() ==
                    MetadataField::UPDATEMETHOD_ONRECORDEDIT)
                {
                    $G_Resource->Set($Field, "now");
                }
            }
        }
    }
}
else
{
    # set flag to indicate error message needed
    $G_NoResourceIdFound = TRUE;
}

# grab error info if present
$G_ErrorCode = isset($_GET["ER"]) ? $_GET["ER"] : NULL;
$G_ErrorFieldIds = isset($_GET["EF"]) ? explode("-", $_GET["EF"]) : NULL;
$G_ErrorInfoOne = isset($_GET["E1"]) ? $_GET["E1"] : NULL;
$G_ErrorInfoTwo = isset($_GET["E2"]) ? $_GET["E2"] : NULL;
