<?PHP
#
#   FILE:  Hide.php (UrlChecker plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Hiding a URL in the URL Checker...");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

$ResourceId = GetFormValue("ResourceId");
$FieldId = GetFormValue("FieldId");

if (Resource::ItemExists($ResourceId))
{
    $Resource = new Resource($ResourceId);
    $Field = $Resource->Schema()->GetField($FieldId);

    if ($Field->Status() == MetadataSchema::MDFSTAT_OK)
    {
        $MyPlugin->HideUrl($Resource, $Field);
    }
}

$GLOBALS["AF"]->SetJumpToPage("P_UrlChecker_Results");
