<?PHP

class ControlledName_Test extends PHPUnit\Framework\TestCase
{
    protected static $TestFieldIds;
    protected static $TestFields;

    /**
    * Prior to running any of the tests, this function is
    * run. It creates all of the test Metadata fields and adds
    * them to class variables $TestFieldIds and $TestFields
    * so each function may use them.
    */
    public static function setUpBeforeClass()
    {
        # construct the schema object
        $Schema = new MetadataSchema(
            MetadataSchema::SCHEMAID_DEFAULT);

        self::$TestFieldIds = array();

        # outline fields to be created
        self::$TestFields = array(
          "ControlledNameTestField" => MetadataSchema::MDFTYPE_CONTROLLEDNAME,
        );

        # create the fields
        foreach (self::$TestFields as $FieldName => $FieldType)
        {
            $TmpField = $Schema->GetItemByName($FieldName);
            if ($TmpField === NULL)
            {
                $TmpField = $Schema->AddField($FieldName, $FieldType);
            }
            $TmpField->IsTempItem(FALSE);
            self::$TestFieldIds[$FieldName] = $TmpField->Id();
        }

    }

    /**
    * After to running the tests, this function is
    * run. It deletes all of the test Metadata fields.
    */
    public static function tearDownAfterClass()
    {
        # construct the schema object
        $Schema = new MetadataSchema(
            MetadataSchema::SCHEMAID_DEFAULT);
        $Database = new Database();

        # drop all of the test fields
        foreach (self::$TestFieldIds as $FieldName => $FieldId)
        {
            $Schema->DropField($FieldId);
        }
    }


    public function testControlledName()
    {
        $MyId = self::$TestFieldIds['ControlledNameTestField'];

        # create a new name
        $TestName = ControlledName::Create("TestName", $MyId);
        $this->assertInstanceOf(
            ControlledName::class, $TestName);
        $this->assertEquals(
            $TestName->FieldId(), $MyId);
        $this->assertEquals(
            $TestName->Name(), "TestName");
        $this->assertEquals(
            $TestName->InUse(), 0);
        $this->assertEquals(
            $TestName->GetAssociatedResources(), array() );
        $this->assertEquals(
            $TestName->VariantName(), NULL);
        $this->assertEquals(
            $TestName->Qualifier(), NULL);

        # test setting / updating / clearing variants
        $this->assertEquals(
            $TestName->VariantName("TestVariant"), "TestVariant");
        $this->assertEquals(
            $TestName->VariantName(), "TestVariant");
        $this->assertEquals(
            $TestName->VariantName("ChangedVariant"), "ChangedVariant");
        $this->assertEquals(
            $TestName->VariantName(), "ChangedVariant");
        $this->assertEquals(
            $TestName->VariantName(FALSE), NULL);
        $this->assertEquals(
            $TestName->VariantName(), NULL);

        # test setting / clearing Qualifiers
        $MyQual = Qualifier::Create("TestQual");
        $this->assertEquals(
            $TestName->Qualifier($MyQual)->Id(), $MyQual->Id());
        $this->assertEquals(
            $TestName->Qualifier()->Id(), $MyQual->Id());

        $this->assertEquals(
            $TestName->QualifierId(NULL), NULL);
        $this->assertEquals(
            $TestName->Qualifier(), NULL);

        $MyQual->Destroy();

        # look up CNID
        $this->assertEquals(
            array($TestName->Id()),
            ControlledName::SearchForControlledName(
                "TestName", $MyId));

        # Create a duplicate of the name
        $this->assertEquals(ControlledName::ControlledNameExists(
                "TestName", $MyId), TRUE);
        $TestDup = ControlledName::Create("TestName", $MyId);
        $this->assertEquals(
            $TestDup->Id(), $TestName->Id() );

        # load an invalid name
        try
        {
            $ExpIsThrown = FALSE;
            $TestInv = new ControlledName(-5000);
        }
        catch (Exception $E)
        {
            $ExpIsThrown = TRUE;
            $this->assertEquals(get_class($E), "InvalidArgumentException");
        }
        $this->assertEquals($ExpIsThrown, TRUE);

        # delete a name
        $TestName->Delete(TRUE);
    }
}
