<?PHP
#
#   FILE:  RequestAccount.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("New User Sign-Up");

# set up expectations for incoming form
$ErrorCodes = UserEditingUI::GetAdditionalErrorCodes(
    GetFormValue("F_Email", ""));

$SignalResult = $GLOBALS["AF"]->SignalEvent(
    "EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
        array("ErrorList" => $ErrorCodes));
$ErrorCodes = $SignalResult["ErrorList"];

$H_AdditionalHtml = $GLOBALS["AF"]->SignalEvent(
    "EVENT_APPEND_HTML_TO_FORM",
    array("PageName" => "RequestAccount",
          "FormName"=>"NewAccountForm",
          "Labels" => array(),
          "InputElements" => array(),
          "Notes" => array()));

$HasCustomFields = count(CWUser::GetCustomUserFields()) > 0;

$H_ShowAdditionalOptions = $HasCustomFields ||
    (is_array($H_AdditionalHtml["Labels"]) && count($H_AdditionalHtml["Labels"]) > 0);

$AdditionalFields = NULL;
if ($H_ShowAdditionalOptions)
{
    # additional FormUI fields
    $AdditionalFields = array(
    "AdditionalSettings" => array(
        "Type" => "Heading",
        "Label" => "Additonal Settings",
        ),
    );
}

$H_FormUI = new FormUI(UserEditingUI::GetRequestAccountForm(
        NULL, NULL, $AdditionalFields), array());

# don't allow new user signups from spambots
if ($GLOBALS["G_PluginManager"]->PluginEnabled("BotDetector") &&
    $GLOBALS["G_PluginManager"]->GetPlugin("BotDetector")->CheckForSpamBot())
{
    $GLOBALS["AF"]->SetJumpToPage("UnauthorizedAccess");
    return;
}
$ButtonPushed = GetFormValue("Submit");
$H_AccountCreatedSuccessfully = FALSE;

if ($ButtonPushed)
{
    $UserErrorCodes = UserEditingUI::TestUserValues($_POST);

    # check for and handle errors (by returning)
    if (UserEditingUI::UserFormHasErrors($H_FormUI, $UserErrorCodes, $ErrorCodes))
    {
        return;
    }

    # create new user
    $UserFactory = new CWUserFactory();
    $NewUser = $UserFactory->CreateNewUser($_POST["F_UserName"],
                $_POST["F_Password"], $_POST["F_PasswordAgain"],
                $_POST["F_EMail"], $_POST["F_EMailAgain"]);

    # if user creation failed
    if (!is_object($NewUser) || ($NewUser->Status() != U_OKAY))
    {
        # log errors in FormUI
        foreach ($NewUser as $ErrorCode)
        {
            $H_FormUI->LogError($ErrorCode);
        }
        return;
    }

    # send confirmation e-mail
    $MailTemplate = $GLOBALS["G_SysConfig"]->PasswordMailSubject()."\n"
            .$GLOBALS["G_SysConfig"]->PasswordMailBody();
    $FromAddress = $GLOBALS["G_SysConfig"]->PortalName()." <"
            .$GLOBALS["G_SysConfig"]->AdminEmail().">";
    $NewUser->SendEMail($MailTemplate, $FromAddress,
            UserEditingUI::GetActivationEmailSubstitutions(
                    $NewUser));

    # save provided attributes and values
    $UEUI = new UserEditingUI($NewUser);
    $UEUI->UpdateUserAttributes($_POST, TRUE);
    $UEUI->UpdateUserFields(CWUser::GetCustomUserFields());

    # always disable account until activated via confirmation e-mail
    $NewUser->GivePriv(PRIV_USERDISABLED);

    # signal that user has been added
    $AF->SignalEvent("EVENT_USER_ADDED", array(
        "UserId" => $NewUser->Id(), "Password" => $_POST["F_Password"]));

    # set e-mail address and user name for use in page display
    $H_EMailAddress = User::NormalizeEMailAddress($_POST["F_EMail"]);
    $H_UserName = User::NormalizeUserName($_POST["F_UserName"]);

    $H_AccountCreatedSuccessfully = TRUE;
}