<?PHP
#
#   FILE:  ConfirmDeleteMetadataField.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
 * Determine whether the given metadata field is the last enabled tree field.
 * @param MetadataField $Field Tree metadata field
 * @return Bool TRUE if the metadata field is the last tree field, else FALSE
 */
function IsFinalTreeField(MetadataField $Field)
{
    # re-assign browsing field ID if that is what is being deleted
    if ($GLOBALS["G_SysConfig"]->BrowsingFieldId() == $Field->Id())
    {
        $Schema = new MetadataSchema();
        $TreeFields = $Schema->GetFields(MetadataSchema::MDFTYPE_TREE);

        # remove the field to be deleted from the list
        unset($TreeFields[$Field->Id()]);

        return count($TreeFields) < 1;
    }

    return FALSE;
}

# ----- MAIN -----------------------------------------------------------------

global $Field;
global $IsFinalTreeField;

PageTitle("Confirm Metadata Field Deletion");

# make sure the user can access this page
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

$Schema = new MetadataSchema();
$Field = new MetadataField(GetArrayValue($_GET, "Id"));
$IsFinalTreeField = IsFinalTreeField($Field);

# invalid field, go to the main page
if ($Field->Status() != MetadataSchema::MDFSTAT_OK)
{
    $AF->SetJumpToPage("DBEditor");
    return;
}
