<?PHP
#
#   FILE:  UpdateQualifier.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Get list of qualifiers to remove.
*/
function GetRemoveList()
{
    $Schema = new MetadataSchema();

    $Qualifiers = array();
    foreach ($_POST as $Var => $Value)
    {
        if (preg_match("/qid_[0-9]+/", $Var))
        {
            if ($Value != "")
            {
                $Qualifiers[] = $Value;
            }
        }
    }
    return $Qualifiers;
}

/**
* Remove list value.
*/
function RemoveListValue()
{
    $Schema = new MetadataSchema();
    $RFactory = new ResourceFactory();

    $Qualifiers = $_SESSION["Qualifiers"];
    unset($_SESSION["Qualifiers"]);

    foreach ($Qualifiers as $QualifierId)
    {
        $Qualifier = new Qualifier($QualifierId);
        $Schema->RemoveQualifierAssociations($Qualifier);
        $RFactory->ClearQualifier($Qualifier);
        $Qualifier->Delete();
    }
}

/**
* Add list value.
* @param str $NewName Name of new qualifier.
* @param str $NewNamespace Namespace of new qualifier.
* @param str $NewUrl Url of new qualifer.
* @return str Error message is there is any, or NULL if none.
*/
function AddListValue($NewName, $NewNamespace, $NewUrl)
{
    $QualifierFactory = new QualifierFactory();

    # escape quotes
    $NewName = addslashes($NewName);
    $NewNamespace = addslashes($NewNamespace);
    $NewUrl = addslashes($NewUrl);

    # first check to see if it already exists
    if (!empty($NewName))
    {
        if ($QualifierFactory->NameIsInUse($NewName))
        {
            return "<b>Error: </b>".$NewName." already exists";
        }

        # create new qualifier
        $Qualifier = Qualifier::Create();
        $Qualifier->Name($NewName);
        $Qualifier->NSpace($NewNamespace);
        $Qualifier->Url($NewUrl);
    }
    else
    {
        return "<b>Error: </b>No Value Entered";
    }
    return NULL;
}

/**
* Update list value.
*/
function UpdateListValue()
{
    foreach ($_POST as $Var => $Value)
    {
        if (preg_match("/qid_[0-9]+/", $Var))
        {
            if (isset($Value))
            {
                $QualifierId = $Value;
            }
            else
            {
                continue;
            }
        }
        if (preg_match("/qn_[0-9]+/", $Var))
        {
            if (isset($Value))
            {
                $QualifierName = addslashes($Value);
            }
            else
            {
                continue;
            }
            # add check here to see if it already exists
        }
        if (preg_match("/qs_[0-9]+/", $Var))
        {
            if (isset($Value))
            {
                $QualifierNamespace = addslashes($Value);
            }
            else
            {
                continue;
            }
            # add check here to see if it already exists
        }
        if (preg_match("/qu_[0-9]+/", $Var))
        {
            $Value = trim($Value);
            $QualifierUrl = addslashes($Value);
            if (!empty($QualifierName) && isset($QualifierId))
            {
                # create new qualifier
                $Qualifier = new Qualifier($QualifierId);
                $Qualifier->Name($QualifierName);
                $Qualifier->NSpace($QualifierNamespace);
                $Qualifier->Url($QualifierUrl);
                $QualifierId = NULL;
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_NewName;
global $F_NewNamespace;
global $F_NewUrl;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

if (isset($_POST["F_NewName"]))
{
    $F_NewName = $_POST["F_NewName"];
}
if (isset($_POST["F_NewName"]))
{
    $F_NewNamespace = $_POST["F_NewNamespace"];
}
if (isset($_POST["F_NewUrl"]))
{
    $F_NewUrl = $_POST["F_NewUrl"];
}
if (isset($_POST["OkayToDelete"]))
{
    $OkayToDelete = $_POST["OkayToDelete"];
}
else
{
    $OkayToDelete = NULL;
}
if (isset($_POST["Submit"]))
{
    $Submit = $_POST["Submit"];
}
else
{
    $Submit = NULL;
}

$ErrorMessages = array();

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    # cancel from confirm delete
    if ($OkayToDelete)
    {
        $AF->SetJumpToPage("AddQualifier");
    }
    else
    {
        $AF->SetJumpToPage("SysAdmin");
    }
    return;
}
else if (substr($Submit, 0, 6) == "Delete")
{
    if ($OkayToDelete)
    {
        RemoveListValue();
    }
    # give user a second chance
    else
    {
        $Qualifiers = GetRemoveList();
        if (count($Qualifiers) > 0)
        {
            $_SESSION["Qualifiers"] = $Qualifiers;
            $AF->SetJumpToPage("ConfirmDeleteQualifier");
            return;
        }
        else
        {
            $ErrorMessages[] = "<b>Error: </b>No Qualifiers selected";
        }

    }
}
else if (substr($Submit, 0, 15) == "Update Selected")
{
    UpdateListValue();
}
else if (substr($Submit, 0, 3) == "Add" ||
    (empty($Submit) && isset($F_NewName)))
{
    $ErrorMessages[] = AddListValue($F_NewName, $F_NewNamespace, $F_NewUrl);
}

$_SESSION["ErrorMessages"] = $ErrorMessages;
$AF->SetJumpToPage("AddQualifier");

?>
