<?PHP
#
#   FILE:  EditTopicComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (isset($_POST["F_TopicName"]) && isset($_GET["TI"])
        && Topic::ItemExists(intval($_GET["TI"])))
{
    $Topic = new Topic(intval($_GET["TI"]));
    $ForumModerator = (new Forum($Topic->ForumId()))->ModeratorId();

    # check authorization
    if (($GLOBALS["G_User"]->Id() != $ForumModerator)
            && !CheckAuthorization(PRIV_SYSADMIN))
    {
        DisplayUnauthorizedAccessPage();
        return;
    }

    # updated the TopicName, removing unwanted HTML
    $Topic->TopicName(StripXSSThreats( $_POST["F_TopicName"]) );

    # then bounce back to the topic index page:
    $GLOBALS["AF"]->SetJumpToPage("index.php?P=TopicMessages"
                       ."&TI=".$Topic->TopicId() );
}
else
{
    DisplayUnauthorizedAccessPage();
    return;
}
