<?PHP
#
#   FILE:  EventReports.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Helper function to deal with summary arrays.
* @param array $Array Array to modify.
* @param string $Key Key to increment.
*/
function CreateOrIncrement(&$Array, $Key)
{
    if (!isset($Array[$Key]))
    {
        $Array[$Key] = 1;
    }
    else
    {
        $Array[$Key]++;
    }
}


# ----- MAIN -----------------------------------------------------------------

PageTitle("Event Usage Metrics");

# make sure user has sufficient permission to view report
if (!CheckAuthorization(PRIV_COLLECTIONADMIN)) {  return;  }

# check to be sure that the CalendarEvents plugin is actually enabled
#  before doing other things
if (!$GLOBALS["G_PluginManager"]->PluginEnabled("CalendarEvents") ){
    CheckAuthorization(-1);
    return;
}

# grab ahold of the relevant metrics objects
$Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
$Reporter = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsReporter");

$CalendarEvents = $GLOBALS["G_PluginManager"]->GetPlugin("CalendarEvents");

$Now = time();

$Past = array(
    "Week"  => $Now -   7 * 86400,
    "Month" => $Now -  30 * 86400,
    "Year" => $Now - 365 * 86400
);

$H_WeekAgo  = date('Y-m-d', $Past["Week"]);
$H_MonthAgo = date('Y-m-d', $Past["Month"]);
$H_YearAgo  = date('Y-m-d', $Past["Year"]);

# new events per day
$DB = new Database();
$DB->Query(
    "SELECT DATE(DateOfRecordCreation".$CalendarEvents->GetSchemaId().") AS D,"
    ." COUNT(*) AS CNT FROM Resources"
    ." WHERE SchemaId=".$CalendarEvents->GetSchemaId()
    ." GROUP BY D");

$H_EventsAddedPerDay = array();
while ($Row = $DB->FetchRow())
{
    $TS = strtotime($Row["D"]);
    $H_EventsAddedPerDay[$TS] = $Row["CNT"];
}

# event views per day
$H_ViewsByDay = array();
$H_TopViews = array(
    "Week" => array(),
    "Month" => array(),
    "Year" => array() );
foreach ($Recorder->GetEventData(
             "CalendarEvents", "ViewEvent",
             NULL, NULL, NULL,
             NULL, NULL, $Reporter->ConfigSetting("PrivsToExcludeFromCounts"),
             0, NULL) as $Event)
{
    $TS = strtotime(date('Y-m-d', strtotime($Event["EventDate"])));
    if (!isset($H_ViewsByDay[$TS]))
    {
        $H_ViewsByDay[$TS] = 0;
    }
    $H_ViewsByDay[$TS]++;

    foreach (array("Week","Month","Year") as $Period)
    {
        if ($Past[$Period] < $TS)
        {
            CreateOrIncrement($H_TopViews[$Period], $Event["DataOne"]);
        }
    }
}

# event shares per day

# get a list of the ResourceIds for all events, use it to filter shares
$EventFactory = new ResourceFactory( $CalendarEvents->GetSchemaId() );
$EventIds = array_flip($EventFactory->GetItemIds());

$H_SharesByDay = array();
$H_TopShares = array(
    "Week" => array(),
    "Month" => array(),
    "Year" => array() );

$ShareTypeMap = array(
    SocialMedia::SITE_EMAIL => 0,
    SocialMedia::SITE_FACEBOOK => 1,
    SocialMedia::SITE_TWITTER => 2,
    SocialMedia::SITE_LINKEDIN => 3,
    SocialMedia::SITE_GOOGLEPLUS => 4
    );

foreach ($Recorder->GetEventData(
             "SocialMedia", "ShareResource",
             NULL, NULL, NULL,
             NULL, NULL, $Reporter->ConfigSetting("PrivsToExcludeFromCounts"),
             0, NULL) as $Event)
{
    # skip non-event shares
    if (!isset($EventIds[$Event["DataOne"]]))
    {
        continue;
    }

    $TS =  strtotime(date('Y-m-d', strtotime($Event["EventDate"])));
    if (!isset($H_SharesByDay[$TS]))
    {
        $H_SharesByDay[$TS] = array(0, 0, 0, 0, 0);
    }
    $H_SharesByDay[$TS][$ShareTypeMap[$Event["DataTwo"]]]++;

    foreach (array("Week","Month","Year") as $Period)
    {
        if ($Past[$Period] < $TS)
        {
            CreateOrIncrement($H_TopShares[$Period], $Event["DataOne"]);
        }
    }
}

# most viewed and shared events
foreach (array("Week", "Month", "Year") as $Period)
{
    arsort($H_TopViews[$Period]);
    arsort($H_TopShares[$Period]);
}

if (isset($_GET["JSON"]))
{
    $GLOBALS["AF"]->SuppressHTMLOutput();
    header("Content-Type: application/json; charset="
           .$GLOBALS["G_SysConfig"]->DefaultCharacterSet(), TRUE);

    print json_encode(array(
        "TopViews" => $H_TopViews,
        "TopShares" => $H_TopShares,
        "EventsAdded" => MetricsReporter::FormatDateKeys($H_EventsAddedPerDay),
        "ViewsByDay" => MetricsReporter::FormatDateKeys($H_ViewsByDay),
        "SharesByDay" => MetricsReporter::FormatDateKeys($H_SharesByDay),
    ));
    return;
}