<?PHP
#
#   FILE:  AddTopicComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# Bail if user lacks required privs
if (!CheckAuthorization( PRIV_POSTTOFORUMS, PRIV_FORUMADMIN, PRIV_SYSADMIN ))
{  return;  }

# Bail if required params weren't passed in
if (!isset($_GET["FI"]) ||
    !(isset($_POST["F_Body"]) || isset($_SESSION["Body"])) ||
    !(isset($_POST["F_Subject"]) || isset($_SESSION["Subject"])) ||
    !(isset($_POST["F_TopicName"]) || isset($_SESSION["TopicName"])) ||
    !isset($_POST["F_Submit"]))
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

$ForumId = intval($_GET["FI"]);

$Body = $_POST["F_Body"];
$Subject = $_POST["F_Subject"];
$TopicName = $_POST["F_TopicName"];

$F_Submit = $_POST["F_Submit"];

if ($F_Submit == "Add New Topic and Post Message")
{
    if (strlen($TopicName) && strlen($Subject) && strlen($Body))
    {
        global $G_User;

        $Forum = new Forum($ForumId);
        $TopicId = $Forum->AddTopic($G_User, $TopicName, $Subject, $Body);

        $AF->SetJumpToPage("index.php?P=TopicMessages&TI=".$TopicId);
    }
    else
    {
        $ErrorMessages[] = "Error: One or more missing values. ".
            "Make sure all values are filled in.";

        $_SESSION["ErrorMessages"] = $ErrorMessages;
        $_SESSION["Subject"]     = $Subject;
        $_SESSION["Body"]        = $Body;
        $_SESSION["TopicName"]   = $TopicName;

        $AF->SetJumpToPage("index.php?P=AddTopic&FI=".$ForumId);
    }
}
else if ($F_Submit == "Preview" || $F_Submit == "Edit Message" )
{
    $_SESSION["Subject"] = $Subject;
    $_SESSION["Body"] = $Body;
    $_SESSION["TopicName"] = $TopicName;

    if ($F_Submit == "Preview") {
        $AF->SetJumpToPage("index.php?P=PreviewTopic&FI=".$ForumId); }
    else {
        $AF->SetJumpToPage("index.php?P=AddTopic&FI=".$ForumId); }
}
else if ($F_Submit == "Cancel")
{
    $AF->SetJumpToPage("index.php?P=ForumTopics&FI=".$ForumId);
}
