<?PHP
#
#   FILE:  F-Folders_UserNameSearchCallback.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
 * Highlight (insert <b></b> tags) the search string in a term.
 * @param string $SS The search string to highlight
 * @param string $Term The term which to insert <b> tags to
 */
function HighlightSearchString($SS, $Term)
{
    $Result = "";
    # used to track which letter in the $SS are we currently matching
    $CurrentMatchingIndex = 0;
    # used to track whether current matching letter is the first in a chunk
    $CountinueMatching = FALSE;
    $TermLen = strlen($Term);
    for ($i = 0; $i < $TermLen; $i++)
    {
        # if the entire $SS has been matched, finish highlight with </b>
        # and append the rest of the $Term
        if ($CurrentMatchingIndex >= strlen($SS))
        {
            $Result .= "</b>" . substr($Term, $i);
            break;
        }


        $CurrentMatching = substr($SS, $CurrentMatchingIndex, 1);
        $CurrentTermLetter = substr($Term, $i, 1);

        # compare current matching letter with the current term letter
        if (strcasecmp($CurrentMatching, $CurrentTermLetter) == 0)
        {
            # if we are not continuing the match, this current matching letter
            # must be the first in the chunk, therefore insert the opening
            # <b> in front of the term
            if (!$CountinueMatching)
            {
                // insert <b> in front
                $Result .= "<b>";
                $CountinueMatching = TRUE;
            }

            $Result .= $CurrentTermLetter;
            $CurrentMatchingIndex++;
        }
        else
        {
            # if the current matching letter and the current term letter are not
            # the same, and we are still matching, the last matched letter must
            # be the end of the chunk. Therefore insert the closing </b> before
            # we append the current term letter
            if ($CountinueMatching)
            {
                $Result .= "</b>";
                $CountinueMatching = FALSE;
            }

            $Result .= $CurrentTermLetter;
        }
    }

    return $Result;
}


# ----- MAIN -----------------------------------------------------------------
$GLOBALS["AF"]->BeginAjaxResponse();

$SearchString = GetArrayValue($_GET, "SS");
$UserFactory = new UserFactory();
$RawResult = $UserFactory->GetMatchingUsers($SearchString, "UserName", "UserName", 0, 10);
$UserNames = array();
foreach ($RawResult as $Id => $User)
{
    # filter out current user name
    if ($User["UserName"] == $GLOBALS["G_User"]->Name())
    {
        continue;
    }

    $UserNames[$Id] = array(
            "Label" => HighlightSearchString($SearchString, $User["UserName"]),
            "Value" => $User["UserName"]
        );
}

echo json_encode($UserNames);