<?PHP
#
#   FILE:  ImportUsers.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!empty($_SESSION["ErrorMessage"]))
{
    $H_ErrorMessage = $_SESSION["ErrorMessage"];
    unset($_SESSION["ErrorMessage"]);
}

# if user shut down the window or go to other pages while importing
#       is not finished, these will not be cleared
foreach (array("UserCount", "FSeek", "TempFile",
        "LineCount", "ErrorMessages", "LastUserName", "PrivNotFound",
        "DuplicateEntries", "UsersProcessed") as $Var)
{
    if (isset($_SESSION[$Var]))
    {
        unset($_SESSION[$Var]);
    }
}

PageTitle("Import Users");

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

?>
