<?PHP
#
#   FILE:  OpenIdServer.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

/**
* A plugin allowing CWIS to function as an OpenId provider, so that
* users can log in to *other* sites with their CWIS account.
*/
class OpenIdServer extends Plugin
{
    /**
    * Register the OpenIdServer plugin.
    * @see Plugin::Register
    */
    public function Register()
    {
        $this->Name = "OpenID Server";
        $this->Version = "1.0.3";
        $this->Description =
            "Allows other sites to authenticate against the users registered on "
            ."this site using "
            ."<a href=\"http://openid.net\" target=\"_blank\">OpenID</a>, ";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
            "CWISCore" => "1.9.0"
            );
    }

    /**
    * Install the OpenIdServer plugin.
    * @see Plugin::Install
    */
    public function Install()
    {
        $this->Upgrade("X-NO-VERSION-X");
    }

    /**
    * Upgrade the OpenIdServer plugin.
    * @param string $PreviousVersion Previous installed version.
    * @see Plugin::Upgrade
    */
    public function Upgrade($PreviousVersion)
    {
        $DB = new Database();

        switch ($PreviousVersion)
        {

            case "1.0.0":
            case "1.0.1":
                $DB->Query("DROP TABLE OidTrustMap");
            case "X-NO-VERSION-X":
                $DB->Query("CREATE TABLE OpenIdServer_TrustMap ("
                           ."UserName VARCHAR(32), Site VARCHAR(32), "
                           ."PRIMARY KEY (UserName, Site))");
            default:
        }
    }
}
