<?PHP
#
#   FILE:  TrackUserComments.php
#
#   FUNCTIONS PROVIDED:
#     - PrintPrevUserCommentLink()
#     - PrintNextUserCommentLink()
#     - NextUserCommentsAvailable()
#     - PreviousUserCommentsAvailable()
#     - PrintNumberOfUserComments()
#     - PrintUserCommentsTableRows()
#
#   FUNCTIONS EXPECTED:
#     - PrintForumMessage()
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

PageTitle("Track User Comments");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintPrevUserCommentLink()
{
    global $SysConfig;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;

    $NumUserComments = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $UserCommentOffset + $NumUserComments;

    print "index.php?P=TrackUserComments&amp;UserCommentOffset=".$Offset;
}

function PrintNextUserCommentLink()
{
    global $SysConfig;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;

    $NumUserComments = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $UserCommentOffset - $NumUserComments;

    print "index.php?P=TrackUserComments&amp;UserCommentOffset=".$Offset;
}

function NextUserCommentsAvailable()
{
    global $SysConfig;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;

    $NumUserComments = $SysConfig->NumAnnounceOnHomePage();
    return ($UserCommentOffset >= $NumUserComments) ? TRUE : FALSE;
}

function PreviousUserCommentsAvailable()
{
    global $MoreUserComments;
    return $MoreUserComments;
}

function PrintNumberOfUserComments()
{
    print "10";
}

function PrintUserCommentsTableRows()
{
    global $User;
    global $DB;
    global $SysConfig;
    global $MoreUserComments;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;

    # if function to supply announcement DB query is available
    if (function_exists("SupplyUserCommentDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyUserCommentDisplayQuery(
                $MaxNumberOfDaysToGoBackForUserComments, 10);
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Messages "
                ."WHERE ParentId > 0 "
                ."AND ParentType = 2 "
                ."ORDER BY DatePosted DESC "
                ."LIMIT ${UserCommentOffset}, "
                ."999999999";
    }

    # query database for appropriate announcements
    $UserCommentDB = new Database();
    $UserCommentDB->Query($DisplayQuery);

    # determine number of announcements to display
    $MaxNumberOfUserCommentsToDisplay=min(10,
        $UserCommentDB->NumRowsSelected());

    # determine if previous link should be displayed or not
    $MoreUserComments = ($UserCommentDB->NumRowsSelected() <=
            $MaxNumberOfUserCommentsToDisplay) ? false : true;

    # if announcements found
    if ($UserCommentDB->NumRowsSelected() > 0)
    {
        $Index = 0;
        # for each announcement
        while ($Index++ < $MaxNumberOfUserCommentsToDisplay)
        {
            $UserComment = $UserCommentDB->FetchRow();

            $MessageId = $UserComment["MessageId"];
            $ResourceId = $UserComment["ParentId"];

            $Message = new Message($MessageId);
            $Resource = new Resource($ResourceId);

            $EditLink = "index.php?P=AddResourceComment"
                ."&amp;ResourceId=".$ResourceId
                ."&amp;MessageId=".$MessageId;
            $DeleteLink = "index.php?P=AddResourceComment"
                ."&amp;ResourceId=".$ResourceId
                ."&amp;MessageId=".$MessageId;
            $SpamLink = $User->HasPriv(PRIV_FORUMADMIN, PRIV_USERADMIN) ?
                "index.php?P=CleanSpam"
                ."&amp;PosterId=".$UserComment["PosterId"]
                ."&amp;ResourceId=-1" :
                "";

            # print comment
            PrintForumMessage(
                $Message, TRUE, $EditLink, $DeleteLink, NULL, TRUE, $SpamLink);
        }
    }
    else
    {
        # print row with "no announcements" notice
        PrintNoUserCommentsMessage();
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $MoreUserComments;

if (!CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN)) {  return;  }
