<?PHP
#
#   FILE:  PluginConfig.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Plugin Uninstall");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

$PluginName = isset($_GET["PN"]) ? $_GET["PN"] : NULL;
$G_Plugin = $G_PluginManager->GetPlugin($PluginName);

# if specified plugin was found and action was requested
if ($G_Plugin && isset($_POST["Submit"]))
{
    # if uninstall was confirmed
    if (($_POST["Submit"] == "Uninstall"))
    {
        # disable plugins that depend on this one
        $Dependents = $G_PluginManager->GetDependents($PluginName);
        foreach ($Dependents as $DependentName)
        {
            $G_PluginManager->PluginEnabled($DependentName, FALSE);
        }

        # uninstall plugin
        $G_PluginManager->UninstallPlugin($PluginName);

        # force a reload to the plugin list
        # (to avoid issues caused by hooks hanging around from uninstalled
        #       or disabled lugins)
        ?><html>
        <head>
            <meta http-equiv="refresh" content="0; URL=index.php?P=Plugins">
        </head>
        <body bgcolor="white">
        </body>
        </html><?PHP
        exit(0);
    }
    else
    {
        # go back to plugin list
        $AF->SetJumpToPage("Plugins");
    }
}
else
{
    # if specified plugin was found
    if ($G_Plugin)
    {
        # load list of enabled plugins that depend on this one
        $G_Dependents = $G_PluginManager->GetDependents($PluginName);
        foreach ($G_Dependents as $Index => $Dependent)
        {
            if (!$G_PluginManager->PluginEnabled($Dependent))
            {
                unset($G_Dependents[$Index]);
            }
        }
    }
}

