<?PHP
#
#   FILE:  ActivateAccount.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("New Account Activation");

# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# ensure the $H_UserName variable is declared
$H_UserName = NULL;

# retrieve user name and confirmation code from URL or form
if (isset($_GET["UN"]) && strlen(trim($_GET["UN"])))
{
    $H_UserName = $_GET["UN"];
}
elseif (isset($_POST["F_UserName"])
        && strlen(trim($_POST["F_UserName"])))
{
    $H_UserName = $_POST["F_UserName"];
}
if (isset($_GET["AC"]) && strlen(trim($_GET["AC"])))
{
    $ActivationCode = $_GET["AC"];
}
elseif (isset($_POST["F_ActivationCode"])
        && strlen(trim($_POST["F_ActivationCode"])))
{
    $ActivationCode = $_POST["F_ActivationCode"];
}

# assume that all checks/actions will fail
$H_UserFound = FALSE;
$H_AccountActivated = FALSE;
$H_AccountAlreadyActivated = FALSE;
$H_EmailChanged = FALSE;
$H_NeedsPassword = FALSE;

# FormUI fields to be excluded
$ExcludedFields = array("UserName", "EMail", "EMailAgain");

$H_AdditionalHtml = $GLOBALS["AF"]->SignalEvent(
    "EVENT_APPEND_HTML_TO_FORM",
    array("PageName" => "RequestAccount",
          "FormName"=>"NewAccountForm",
          "Labels" => array(),
          "InputElements" => array(),
          "Notes" => array()));

$HasCustomFields = count(CWUser::GetCustomUserFields()) > 0;

$H_ShowAdditionalOptions = $HasCustomFields || count($H_AdditionalHtml["Labels"] > 0);

$AdditionalFields = NULL;
if ($H_ShowAdditionalOptions)
{
    # additional FormUI fields
    $AdditionalFields = array(
    "AdditionalSettings" => array(
        "Type" => FormUI::FTYPE_HEADING,
        "Label" => "Additonal Settings",
        ),
    );
}

$FormFields = UserEditingUI::GetRequestAccountForm
        (NULL, $ExcludedFields, $AdditionalFields);

$H_FormUI = new FormUI($FormFields, array());

# if user name and confirmation code found
if (isset($H_UserName) && isset($ActivationCode))
{
    # check user name
    $H_NewUser = new SPTUser($H_UserName);

    # if user name was valid
    if ($H_NewUser->Status() == U_OKAY)
    {
        # note that user was found
        $H_UserFound = TRUE;

        # if account is already activated
        if ($H_NewUser->IsActivated())
        {
            # note that account was already activated
            $H_AccountAlreadyActivated = TRUE;
            $OldEmail = $H_NewUser->Get("EMail");
            $NewEmail = $H_NewUser->Get("EMailNew");

            # Check if we're actually servicing a mail change request
            if ($H_NewUser->IsMailChangeCodeGood($ActivationCode) &&
                $OldEmail != $NewEmail )
            {
                $H_NewUser->Set("EMail", $NewEmail);
                $H_NewUser->Set("EMailNew", "");
                #Signal the email change
                $AF->SignalEvent("EVENT_USER_EMAIL_CHANGED", array(
                                     "UserId" => $H_NewUser->Id(),
                                     "OldEmail" => $OldEmail,
                                     "NewEmail" => $NewEmail));
                $H_EmailChanged = TRUE;
            }
        }
        else
        {
            # attempt to confirm code
            $H_AccountActivated = $H_NewUser->IsActivationCodeGood($ActivationCode);

            # if code was confirmed
            if ($H_AccountActivated)
            {
                # enable account for login
                $H_NewUser->RevokePriv(PRIV_USERDISABLED);
                $H_NewUser->IsActivated(TRUE);

                # signal that user has been activated
                $AF->SignalEvent("EVENT_USER_VERIFIED",
                        array("UserId" => $H_NewUser->Id()));

                $UserResource = $H_NewUser->GetResource();

                $H_NeedsPassword = $UserResource->Get("Has No Password");
            }
        }
    }
}
