<?PHP
#
#   FILE:  AddClassification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* print Qualifier option list
* @param int $FieldId ID of metadata field for classification.
*/
function PrintQualifierList($FieldId)
{
    $Field = new MetadataField($FieldId);

    if ($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_QualifierId", $Items, $Field->DefaultQualifier(),
            0, 1, NULL, FALSE);
    }
    else if ($Field->DefaultQualifier() > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier)) {
            print $Qualifier->Name(); }
    }
    else {
        print "None"; }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

$H_ParentId = GetFormValue("ParentId", Classification::NOPARENT);
$H_FieldId = GetFormValue("FieldId", FALSE);
$H_ErrMsgs = GetFormValue("ErrMsgs", array());


