ALTER TABLE MetadataFields
    ADD COLUMN CopyOnResourceDuplication INT DEFAULT 1;

UPDATE MetadataFields
    SET CopyOnResourceDuplication=0 WHERE
    SchemaId=0 AND FieldName IN ("Cumulative Rating", "Date Last Modified");

ALTER TABLE SavedSearches ADD COLUMN LastMatchingIds MEDIUMTEXT DEFAULT NULL;

CREATE TABLE IF NOT EXISTS SearchItemTypes (
    ItemId          INT NOT NULL,
    ItemType        SMALLINT NOT NULL,
    INDEX           Index_IT (ItemId, ItemType)
);

-- add page caching support for ApplicationFramework
CREATE TABLE IF NOT EXISTS AF_CachedPages (
    CacheId     INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Fingerprint TEXT DEFAULT NULL,
    PageContent MEDIUMBLOB DEFAULT NULL,
    CachedAt    TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX       Index_F (Fingerprint(48)),
    INDEX       Index_A (CachedAt)
);
CREATE TABLE IF NOT EXISTS AF_CachedPageTags (
    TagId       INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Tag         TEXT DEFAULT NULL,
    INDEX       Index_T (Tag(16)),
    INDEX       Index_I (TagId)
);
CREATE TABLE IF NOT EXISTS AF_CachedPageTagInts (
    TagId       INT NOT NULL,
    CacheId     INT NOT NULL,
    INDEX       Index_T (TagId),
    INDEX       Index_CT (CacheId, TagId)
);
ALTER TABLE ApplicationFrameworkSettings ADD COLUMN PageCacheEnabled INT DEFAULT 0;
ALTER TABLE ApplicationFrameworkSettings ADD COLUMN PageCacheExpirationPeriod INT DEFAULT 600;

-- drop sys config column that was moved to ApplicationFramework
ALTER TABLE SystemConfiguration DROP COLUMN UseMinimizedJavascript;

-- new columns for ApplicationFramework setting values
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN UrlFingerprintingEnabled INT DEFAULT 1;
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN ScssSupportEnabled INT DEFAULT 1;
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN GenerateCompactCss INT DEFAULT 1;
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN UseMinimizedJavascript INT DEFAULT 1;
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN JavascriptMinimizationEnabled INT DEFAULT 1;

