<?PHP
#
#   FILE:  TopicMessages.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Topic Messages");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function CheckForModeratorOrSysAdmin($Forum)
{
    global $G_User;

    return
        ($User->Get("UserId") == $Forum->ModeratorId() &&
         $User->HasPriv(PRIV_FORUMADMIN))
        || $User->HasPriv(PRIV_SYSADMIN) ;
}

function DisplayMessages($Topic)
{
    global $G_User;

    $Messages = $Topic->GetMessageList();
    $MessageCount = count($Messages);

    foreach ($Messages as $MessageId => $Message)
    {
        $Poster = new SPTUser(intval($Message->PosterId()));
        $EditOkay = CheckForEdit( $Message->PosterId(), $Topic );
        $EditLink = "index.php?P=PostMessage"
            ."&amp;TI=".$Topic->TopicId()
            ."&amp;MI=".$MessageId;
        $DeleteLink = "index.php?P=PostMessage"
            ."&amp;TI=".$Topic->TopicId()
            ."&amp;MI=".$MessageId;

        # see if this user has permission to remove posting privileges
        if (CheckForRemovePostPrivilege()
            && ($Message->PosterId() != $G_User->Id())
            && in_array(strval(PRIV_POSTTOFORUMS), $Poster->GetPrivList()))
        {
            $RemovePostPrivLink = "index.php?P=CleanSpam"
                ."&amp;TI=".$Topic->TopicId()."&amp;PI=".$Message->PosterId() ;
        }
        else
        {
            $RemovePostPrivLink = NULL;
        }

        PrintForumMessageWithMessage($Message, $EditOkay, $EditLink, $DeleteLink,
                          $RemovePostPrivLink, FALSE, NULL, TRUE);
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# see if user has permission to edit the message
function CheckForEdit($PosterId, $Topic)
{
    global $G_User;

    $Forum = new Forum($Topic->ForumId());

    return
        $G_User->Get("UserId") == $Forum->ModeratorId() ||
        ($G_User->Get("UserId") == $PosterId && $G_User->HasPriv(PRIV_POSTTOFORUMS)) ||
        $G_User->HasPriv(PRIV_FORUMADMIN) ;
}

# check if user can remove post privilege
function CheckForRemovePostPrivilege()
{
    global $G_User;

    return
        $G_User->HasPriv(PRIV_FORUMADMIN) && $G_User->HasPriv(PRIV_USERADMIN) ;
}

# ----- MAIN -----------------------------------------------------------------

if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages []= "No topic specified";
    return;
}

$H_Topic = new Topic( intval($_GET["TI"]) );

if ($H_Topic->GetErrorStatus() != Topic::OK)
{
    $H_ErrorMessages []= "No such topic";
    return;
}

$H_Forum = new Forum( $H_Topic->ForumId() );

# update the viewcount every time page is loaded
$H_Topic->ViewCount( $H_Topic->ViewCount() + 1);
