<?PHP
#
#   FILE: EditMetadataSchema.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Get the metadata schema that is being edited.
* @param MetadataSchema $SchemaToUse Metadata schema that is edited for setting.
* @return Returns the metadata schema that is being edited.
*/
function GetMetadataSchema(MetadataSchema $SchemaToUse=NULL)
{
    static $Schema;

    if (!isset($Schema) || !is_null($SchemaToUse))
    {
        $Schema = $SchemaToUse;
    }

    return $Schema;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Get the page with necessary parameters when returning to the DBEditor page.
* @param mixed $Value MetadataSchema object, MetadataField object, or a schema
*      ID.
* @return Returns the page to return to.
*/
function GetReturnToPage($Value)
{
    $Suffix = "";

    # get the suffix from a metadata schema if not using the default schema
    if ($Value instanceof MetadataSchema)
    {
        if ($Value->Id() != MetadataSchema::SCHEMAID_DEFAULT)
        {
            $Suffix = "&SC=" . urlencode($Value->Id());
        }
    }

    # use the value directly if not using the default schema
    else if (!is_null($Value) && $Value != MetadataSchema::SCHEMAID_DEFAULT)
    {
        $Suffix = "&SC=" . urlencode($Value);
    }

    return "DBEditor" . $Suffix;
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Edit Metadata Schema");

# check authorization
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

# construct the schema object
$SchemaId = GetArrayValue($_GET, "SC", MetadataSchema::SCHEMAID_DEFAULT);
$H_Schema = new MetadataSchema($SchemaId);
GetMetadataSchema($H_Schema);

# the action to be performed, if any
$Action = GetFormValue("F_Submit");

# variables for holding privilege errors
$H_PrivilegesError = NULL;

$H_PrivsetUI = new PrivilegeEditingUI($SchemaId);

# if user canceled editing
if ($Action == "Cancel")
{
    # go back to the list of fields for the schema
    $AF->SetJumpToPage(GetReturnToPage($H_Schema));
    return;
}
# else if user requested changes be saved
elseif ($Action == "Save Changes")
{
    try
    {
        # attempt to extract modified privsets from form
        $NewPrivsets = $H_PrivsetUI->GetPrivilegeSetsFromForm();

        # update each type of privilege
        foreach (array("ViewingPrivileges", "AuthoringPrivileges", "EditingPrivileges")
                 as $PrivilegeType)
        {
            $H_Schema->{$PrivilegeType}($NewPrivsets[$PrivilegeType]);
        }

        # nuke the page cache in case permission changes affect what is displayed
        $AF->ClearPageCache();
        SPTImage::ClearImageSymlinks();
    }
    catch (Exception $Exception)
    {
        # couldn't update the privileges
        $H_PrivilegesError = $Exception->getMessage();
    }

    # if there were no errors
    if (is_null($H_PrivilegesError))
    {
        # go back to the list of fields for the schema
        $AF->SetJumpToPage(GetReturnToPage($H_Schema));
        return;
    }
}
