<?PHP
#
#   FILE:  ChangeFolderDescription.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $Folder;
global $Id;
global $Description;
global $ReturnTo;

PageTitle("Change Folder Description");

# make sure the user is logged in
if (!CheckAuthorization())
{
    return;
}

# redirect if no folder ID is given
if (!isset($_GET["FolderId"]))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}


$FolderFactory = new Folders_FolderFactory($GLOBALS["G_User"]->Id());
$ResourceFolder = $FolderFactory->GetResourceFolder();
$Folder = new Folders_Folder(GetArrayValue($_GET, "FolderId"));

# redirect if the user should not see the folder
if (!$ResourceFolder->ContainsItem($Folder->Id()))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

$Id = $Folder->Id();
$Description = $Folder->Note();
$ReturnTo = defaulthtmlentities(GetArrayValue($_GET, "ReturnTo"));