-- add configurable default user privileges and default sort field
ALTER TABLE SystemConfiguration ADD DefaultUserPrivs TEXT;
ALTER TABLE SystemConfiguration ADD DefaultSortField INT AFTER DefaultRecordsPerPage;

-- set default privs
UPDATE SystemConfiguration
    SET DefaultUserPrivs = 'a:2:{i:0;s:1:"9";i:1;s:2:"10";}';

-- add image preview privilege setting
ALTER TABLE MetadataFields ADD COLUMN TreeBrowsingPrivilege INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN ShowQualifiers INT DEFAULT 0;
ALTER TABLE MetadataFields
        ADD COLUMN IncludeInSortOptions INT DEFAULT 1 AFTER IncludeInAdvancedSearch;
ALTER TABLE MetadataFields
        ADD COLUMN ImagePreviewPrivilege INT DEFAULT 0 AFTER DefaultAltText;
UPDATE MetadataFields SET ShowQualifiers = 1;

-- New tables for the secure login machinery
CREATE TABLE LoginKeys (
  KeyPair TEXT,
  CreationTime TIMESTAMP
);

CREATE TABLE UsedLoginTokens (
  Token TEXT,
  KeyCTime TIMESTAMP,
  UserName TEXT
);
