<?PHP

$GLOBALS["G_ErrMsg"] = Upgrade241_UpdateAltTextFromDefaultAltText();

/**
 * Since the alt text value wasn't being set in previous versions, set it for
 * existing images that don't have a value already set (which should be all of
 * them in most cases).
 * @return NULL if nothing goes wrong and an error message otherwise
 */
function Upgrade241_UpdateAltTextFromDefaultAltText()
{
    $ImageFields = Upgrade241_GetImageFields();

    # an error occurred when fetching the image fields
    if ($ImageFields === FALSE)
    {
        return "Could not get any image metadata fields.";
    }

    # there are no image fields, so return
    if (count($ImageFields) === 0)
    {
        return;
    }

    # hold any errors that occur when updating the alt text
    $FieldsFailedToUpgrade = array();

    foreach ($ImageFields as $ImageField)
    {
        # update the alt text for this field
        $Result = Upgrade241_SetAltText(
            Upgrade241_GetDBFieldName($ImageField["FieldName"]),
            $ImageField["DefaultAltText"]);

        # couldn't update the alt text
        if ($Result === FALSE)
        {
            $FieldsFailedToUpgrade[] = $ImageField["FieldName"];
        }
    }

    # there were errors when updating the alt text values
    if (count($FieldsFailedToUpgrade) > 1)
    {
        $FieldsFailedToUpgradeString = implode(", ", $FieldsFailedToUpgrade);

        return "Could not update the alt text values for the "
              .$FieldsFailedToUpgradeString." field(s).";
    }
}

/**
 * Get the DBFieldName value for the given metadata field name.
 * @param string $Name metadata field name
 * @return the DBFieldName value
 */
function Upgrade241_GetDBFieldName($Name)
{
    return preg_replace("/[^a-z0-9]/i", "", $Name);
}

/**
 * Set the alt text value for all images for a certain field.
 * @param string $DBFieldName the database column name for the image IDs in the
 *   Resources table
 * @param string $AltText the text to set for the alt text column
 * @return TRUE if the update was successful and FALSE otherwise
 */
function Upgrade241_SetAltText($DBFieldName, $AltText)
{
    $Link = mysqli_connect(
        $GLOBALS["FVars"]["F_DBHost"],
        $GLOBALS["FVars"]["F_DBLogin"],
        $GLOBALS["FVars"]["F_DBPassword"],
        $GLOBALS["FVars"]["F_DBName"]);

    $Result = mysqli_query($Link, "
        UPDATE Images I
        INNER JOIN Resources R ON I.ImageId = R.".$DBFieldName."
        SET I.AltText = '".addslashes($AltText)."'
        WHERE I.AltText = '' OR I.AltText IS NULL");

    # return whether or not the query was successful
    return $Result !== FALSE;
}

/**
 * Get all image fields, if any, and their values.
 * @return an array of image fields or FALSE if an error occured
 */
function Upgrade241_GetImageFields()
{
    $Link = mysqli_connect(
        $GLOBALS["FVars"]["F_DBHost"],
        $GLOBALS["FVars"]["F_DBLogin"],
        $GLOBALS["FVars"]["F_DBPassword"],
        $GLOBALS["FVars"]["F_DBName"]);
    $Result = mysqli_query($Link, "
        SELECT * FROM MetadataFields
        WHERE Fieldtype = 'Still Image'");

    # there was an error when executing the query
    if ($Result === FALSE)
    {
        return FALSE;
    }

    # the resulting rows
    $Rows = array();

    # couldn't find any image fields
    if (mysqli_num_rows($Result) < 1)
    {
        return $Rows;
    }

    # fetch the rows
    while (NULL !== ($Row = mysqli_fetch_assoc($Result)))
    {
        $Rows[] = $Row;
    }

    # an error occurred because there should be at least one row
    if (!count($Rows))
    {
        return FALSE;
    }

    # return the data
    return $Rows;
}
