<?PHP
#
#   FILE:  EditFeed.php (RSSImport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2017 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

# check permissions
CheckAuthorization(PRIV_SYSADMIN);

# retrieve feed ID
$H_FeedId = GetFormValue("ID");
if ($H_FeedId === NULL)
{
    throw new Exception("No feed ID specified.");
}
$H_IsNewFeed = ($H_FeedId == "NEW") ? TRUE : FALSE;

# if editing existing feed
if (!$H_IsNewFeed)
{
    # load feed
    $H_Feed = new RSSImport_Feed($H_FeedId);
}

# set up editing form
$FormFields = array(
        "Feed Heading" => array(
                "Type" => FormUI::FTYPE_HEADING,
                "Label" => "Feed",
                ),
        "Display" => array(
                "Type" => FormUI::FTYPE_FLAG,
                "Label" => "Display",
                "Help" => "Determines whether the RSS feed should be displayed."
                          ." This is useful for temporarily hiding problematic feeds.",
                "Default" => TRUE,
                ),
        "Title" => array(
                "Type" => FormUI::FTYPE_TEXT,
                "Label" => "Title",
                "Help" => "The title of the RSS feed. This should be short but".
                            " descriptive because it is used as the title of the".
                            " feed in the sidebar.",
                "Placeholder" => "(feed title)",
                "Required" => TRUE,
                ),
        "URL" => array(
                "Type" => FormUI::FTYPE_TEXT,
                "Label" => "URL",
                "Help" => "The URL of the RSS feed.",
                "Placeholder" => "(feed url)",
                "Required" => TRUE,
                ),
        "ItemsToDisplay" => array(
                "Type" => FormUI::FTYPE_NUMBER,
                "Label" => "Items to Display",
                "Help" => "The number of items from the RSS feed to display.",
                "MinVal" => 1,
                "MaxVal" => 10,
                "Default" => 5,
                "Required" => TRUE,
                ),
        "DisplayLocations" => array(
                "Type" => FormUI::FTYPE_OPTION,
                "Label" => "Display Locations",
                "Help" => "The pages within the site on which to display the RSS feeds.",
                "Options" => RSSImport_Feed::PossibleDisplayLocations(),
                "Required" => TRUE,
                ),
        "RefreshRate" => array(
                "Type" => FormUI::FTYPE_OPTION,
                "Label" => "Refresh Rate",
                "Help" => "Determines how often the RSS feed should be checked".
                          " for updates.",
                "Options" => RSSImport_Feed::PossibleRefreshRates(),
                "Default" => RSSImport_Feed::REFRATE_3600,
                "Required" => TRUE,
                ),
        );

# if editing an existing feed
$FormValues = NULL;
if (!$H_IsNewFeed)
{
    # load existing values
    $FormValues = array(
            "Display" => $H_Feed->Enabled(),
            "Title" => $H_Feed->Title(),
            "URL" => $H_Feed->Url(),
            "ItemsToDisplay" => $H_Feed->NumberItemsToDisplay(),
            "DisplayLocations" => $H_Feed->DisplayLocations(),
            "RefreshRate" => $H_Feed->RefreshRate(),
            );
}

# instantiate form UI
$H_FormUI = new FormUI($FormFields, $FormValues);

$ButtonPushed = GetFormValue("Submit");
switch ($ButtonPushed)
{
    case "Add":
    case "Save":
        # check values and bail out if any are invalid
        if ($H_FormUI->ValidateFieldInput())
        {
            return;
        }

        # retrieve values from form
        $NewSettings = $H_FormUI->GetNewValuesFromForm();

        # if adding new feed
        if ($H_IsNewFeed)
        {
            # create new feed
            $H_Feed = RSSImport_Feed::Create();
        }
        else
        {
            # load existing feed
            $H_Feed = new RSSImport_Feed($H_FeedId);

        }

        # save common new attributes for feed
        $H_Feed->Enabled($NewSettings["Display"]);
        $H_Feed->Title($NewSettings["Title"]);
        $H_Feed->Url($NewSettings["URL"]);
        $H_Feed->DisplayLocations($NewSettings["DisplayLocations"]);
        $H_Feed->NumberItemsToDisplay($NewSettings["ItemsToDisplay"]);
        $H_Feed->RefreshRate($NewSettings["RefreshRate"]);


        # return to feed list
        $GLOBALS["AF"]->SetJumpToPage("P_RSSImport_ListFeeds");
        break;

    case "Cancel":
        # return to feed list
        $GLOBALS["AF"]->SetJumpToPage("P_RSSImport_ListFeeds");
        break;
}
