<?PHP
#
#   FILE:  AddQualifier.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
/**
* Print out error messages if they exist.
*/
function PrintErrorMessages()
{
    global $Session;

    $ErrorMessages = $Session->Get("ErrorMessages");

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

/**
* Display qualifier lists for editing.
*/
function DisplayQualifiers()
{
    global $QualifierFactory;
    global $QualifierName;
    global $QualifierNamespace;
    global $QualifierUrl;
    global $QualifierId;
    global $Index;

    if ($QualifierFactory->GetItemCount())
    {
        $Index = 0;
        $QualifierList = $QualifierFactory->GetItemNames();
        foreach ($QualifierList as $QualifierId => $QualifierName)
        {
            $Qualifier = new Qualifier($QualifierId);
            $QualifierNamespace = $Qualifier->NSpace();
            $QualifierUrl = $Qualifier->Url();
            DisplayQualifierSelection();
            $Index++;
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Index;
global $QualifierFactory;
global $QualifierId;
global $QualifierName;
global $QualifierNamespace;
global $QualifierUrl;

$QualifierFactory = new QualifierFactory();

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

PageTitle("Add/Edit Qualifiers");

?>
