<?PHP
#
#   FILE:  ConfirmDelete.php (RSSExport plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Gets the feed URL to display. If there is a clean URL available, it will be
*     used.
* @param object $Feed The feed to get the URL of.
* @return string The URL of the feed.
*/
function GetFeedUrl($Feed)
{
    # if there is no feed don't do anything
    if ($Feed == NULL) return NULL;

    # gather up variables
    global $G_PluginManager;
    $Plugin = $G_PluginManager->GetPlugin("RSSExport");
    $CleanUrlPrefix = $Plugin->ConfigSetting("CleanUrlPrefix");
    $CleanUrl = $Feed->CleanUrl();

    # check if we have a clean URL for the feed, and if we do, return it
    if (strlen($CleanUrlPrefix) && strlen($CleanUrl))
    {
        return "/" . trim($CleanUrlPrefix) . "/" . trim($CleanUrl);
    }

    # otherwise return the normal URL
    return "index.php?P=P_RSSExport_Feed&amp;ID=" . $Feed->Id();
}

# ----- MAIN -----------------------------------------------------------------

global $AF, $G_PluginManager;

# bail out if the user is not allowed to see this page
if (!CheckAuthorization( PRIV_SYSADMIN )) { return; }

$H_FeedId = intval(GetArrayValue($_GET, "ID", -1));

# bail out if we don't have a valid ID
if ($H_FeedId === -1)
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}

# get a copy of the RSSExport plugin
$Plugin = $G_PluginManager->GetPlugin("RSSExport");

# get the available feeds
$H_Feeds = $Plugin->GetFeeds();

# bail out if the feed does not exist
if (!array_key_exists($H_FeedId, $H_Feeds))
{
    $AF->SetJumpToPage("P_RSSExport_ListFeeds");
    return;
}

# get the desired feed
$H_Feed = $H_Feeds[$H_FeedId];
