<?PHP
#
#   FILE:  WhyRecommend.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintRecommendedResource()
{
    global $User;
    global $RecommendedResourceId;

    $Resource = new Resource($RecommendedResourceId);
    PrintRecommendation($Resource,
            "index.php?P=FullRecord&amp;ID=".$RecommendedResourceId,
            $User->HasPriv(PRIV_RESOURCEADMIN),
            "index.php?P=EditResource&amp;ID=".$RecommendedResourceId,
            $Resource->ScaledCumulativeRating());
}

function PrintRecommendationSources()
{
    global $User;
    global $RecommendedResourceId;
    global $ResultsPerPage;

    $ResourceCount = 0;

    # create recommender
    $Recommender = new SPTRecommender;

    # get list of recommendation source resources
    $RecSources = $Recommender->GetSourceList(
            $User->Get("UserId"), $RecommendedResourceId);

    # for each source resource
    foreach ($RecSources as $SourceId => $CorrelationScore)
    {
        # if we have printed the max number of sources
        if ($ResourceCount > $ResultsPerPage)
        {
            # bail out
            continue;
        }

        $ResourceCount++;

        # print resource record
        $Resource = new Resource($SourceId);
        PrintRecommendation($Resource,
                "index.php?P=FullRecord&amp;ID=".$SourceId,
                $Resource->UserCanEdit($User),
                "index.php?P=EditResource.php&amp;ID=".$SourceId,
                $Resource->ScaledCumulativeRating());
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function ParseArguments()
{
    global $ResultsPerPage;
    global $RecommendedResourceId;

    # grab ID of recommended resource
    $RecommendedResourceId = (isset($_GET["rr"])) ? $_GET["rr"] : NULL;

    # set results per page to a default for now
    $ResultsPerPage = 10;
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $RecommendedResourceId;
global $ResultsPerPage;

PageTitle("Recommendation Sources");
ParseArguments();

# if the "rr" key isn't set, go to the resource recommendations page
if (!isset($_GET["rr"]))
{
    $AF->SetJumpToPage("RecommendResources");
}
