<?PHP
#
#   FILE:  UpdateFolderName.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# check authorization and setup HTML suppression and page redirection
if (!Folders_Common::ApiPageCompletion("P_Folders_ManageFolders"))
{
    return;
}

# canceled editing
if (GetArrayValue($_GET, "Cancel"))
{
    return;
}
# get the folders plugin
$FoldersPlugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# set up variables
$Errors = array();

$FolderId = GetArrayValue($_GET, "FolderId");
$FolderName = GetArrayValue($_GET, "FolderName");
$FolderFactory = new Folders_FolderFactory($GLOBALS["G_User"]->Id());

# We need to pass in a folder id, not simply change the default, so we break here
if ($FolderId === NULL)
{
    array_push($Errors, 'E_FOLDERS_NOSUCHFOLDER');
}
else
{
    $Folder = new Folders_Folder($FolderId);
    $ResourceFolder = $FolderFactory->GetResourceFolder();
}

PageTitle("Folders - Change Folder Name");

# ----- MAIN -----------------------------------------------------------------

#only move on if we have a valid folder
if($Folder)
{
    # continue only if the resource folder contains this folder, which implies
    # that the user owns the folder and it's a valid folder of resources
    if ($ResourceFolder->ContainsItem($Folder->Id()))
    {
        # change the name
        $Folder->Name($FolderName);
    }
    else
    {
        # user doesn't own the folder
        array_push($Errors, 'E_FOLDERS_NOTFOLDEROWNER');
    }
}

# ----- PAGE ROUTING  -----------------------------------------------------------------
# handle page routing based on the success/failure above.

# This page does not output any HTML
$GLOBALS["AF"]->SuppressHTMLOutput();

$FoldersPlugin->ProcessPageResponse($Errors, ReachedWithAjax());
