<?PHP
#
#   FILE:  SavedSearchFactory.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2009-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Factory for manipulating SavedSearch objects.
*/
class SavedSearchFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Object constructor.
    */
    function __construct()
    {
        # set up item factory base class
        parent::__construct("SavedSearch", "SavedSearches", "SearchId", "SearchName");
    }

    /**
    * Get all saved searches for a specified user.
    * @param int $UserId ID of user.
    * @return array Array of SavedSearch objects, with saved search IDs
    *       for index.
    */
    function GetSearchesForUser($UserId)
    {
        # return list of searches to caller
        return $this->GetItems("UserId = ".intval($UserId));
    }

    /**
    * Get all searches that should be run according to frequency and last run time.
    * @return array Array of SavedSearch objects, with saved search IDs
    *       for index.
    */
    function GetSearchesDueToRun()
    {
        # retrieve searches with frequency/time values that indicate need to be run
        return $this->GetItems(
                "((Frequency = ".SavedSearch::SEARCHFREQ_HOURLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 hour ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_DAILY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 day ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_WEEKLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 week ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_BIWEEKLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("2 weeks ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_MONTHLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 month ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_QUARTERLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("3 months ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_YEARLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 year ago") + 15))."'))");
    }

    /**
    * Get number of users with saved searches.
    * @return int User count.
    */
    function GetSearchUserCount()
    {
        return $this->DB->Query(
                "SELECT COUNT(DISTINCT UserId) AS UserCount FROM SavedSearches",
                "UserCount");
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}
