<?PHP
#
#   FILE:  F-Blog_PrintSummaryBlock.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print given list or given amount of blog entries from given BlogId inside
* of a table element
*
* @param int $BlogId ID of the blog which the entries are from
* @param int $NumberOrIdsToPrint Array of blog IDs,
*   or the number of entries to print (OPTIONAL)
*/
function Blog_PrintSummaryBlock($BlogId, $NumberOrIdsToPrint = NULL)
{
    $BlogPlugin = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");
    $GLOBALS["AF"]->AddPageCacheTag(
        "ResourceList".$BlogPlugin->GetSchemaId() );
    $BlogEntryFactory = new Blog_EntryFactory($BlogId);
    $NumberToPrint = $BlogPlugin->BlogSetting($BlogId, "EntriesPerPage");
    $BlogName = $BlogPlugin->BlogSetting($BlogId, "BlogName");
    $CheckEntryValidity = FALSE;
    $GLOBALS["AF"]->LoadFunction("Blog_PrintBlogEntry");

    if ($NumberOrIdsToPrint !== NULL)
    {
        if (is_array($NumberOrIdsToPrint))
        {
            $BlogIds = array_intersect($NumberOrIdsToPrint,
                    $BlogEntryFactory->GetItemIds());
        }
        else
        {
            $NumberToPrint = $NumberOrIdsToPrint;
            $BlogIds = $BlogEntryFactory->GetResourceIdsSortedBy(
                    Blog::PUBLICATION_DATE_FIELD_NAME, FALSE);
        }
    }
    else
    {
        $BlogIds = $BlogEntryFactory->GetResourceIdsSortedBy(
                Blog::PUBLICATION_DATE_FIELD_NAME, FALSE);
    }

    $Printed = 0;

    print "<table class=\"BlogList\">\n<tbody>\n";
    while (($Id = array_shift($BlogIds)) !== NULL
             && $Printed < $NumberToPrint)
    {
        $Entry = new Blog_Entry($Id);
        if ($Entry->UserCanView($GLOBALS["G_User"]))
        {
            ?><tr><td class="BlogEntrySummary"><?PHP
            Blog_PrintBlogEntry(new Blog_Entry($Id));
            $Printed++;
            ?></td></tr><?PHP
        }
    }

    if ($Printed == 0)
    {
        print "<tr><td>No ".htmlspecialchars($BlogName)
                      ." entries to display.</td></tr>";

        $BlogSchema = new MetadataSchema(
            $BlogPlugin->GetSchemaId() );
        if ($BlogSchema->UserCanAuthor($GLOBALS["G_User"]))
        {
            print "<tr><td><a href=\"index.php?P=EditResource&amp;"
                ."ID=NEW&amp;SC=".$BlogSchema->Id()."\">"
                ."Add an entry</a></td></tr>";
        }
    }

    print "\n</tbody>\n</table>\n";
}
