<?PHP
#
#   FILE:  ConfirmMailIt.php (MailIt plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

# ----- MAIN -----------------------------------------------------------------

global $G_PluginManager;

# get the resource
$H_Resource = new Resource(intval(GetArrayValue($_GET, "ID", -1)));

# make sure the resource is valid
if ($H_Resource->Status() === -1)
{
    # if not, go back to the full record page
    $GLOBALS["AF"]->SetJumpToPage("index.php?P=FullRecord&ID=" . $Resource->Id());
    return;
}

# get a copy of the MailIt plugin
$Plugin = $G_PluginManager->GetPlugin("MailIt");

# get the header and body config settings
$H_HeaderText = $Plugin->ConfigSetting("HeaderText");
$H_BodyText = $Plugin->ConfigSetting("BodyText");

$Errors = "";
if(array_key_exists("ER",$_GET)){
  $ErrorNumber = $_GET["ER"];
  switch($ErrorNumber)
  {
    case 3;
      $Errors = "<br>The email you are attempting to reach is not valid.</br>";
      break;
  }
}
