<?PHP
#
#   FILE:  ManageFolders.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Print each folder. This function also passes the previous and subsequent
 * items to the folder printing function to facilitate item bubbling.
 * @param Folder $ResourceFolder root resource folder
 * @param array $Folders folders to print
 * @param Folder $SelectedFolder the currently selected folder
 * @return void
 */
function PrintFolders($ResourceFolderId, array $Folders, Folder $SelectedFolder)
{
    # we want to be able to get next and previous values, so use numeric indices
    $Folders = array_values($Folders);

    for ($i = 0; $i < count($Folders); $i++) {
        $Previous = isset($Folders[$i-1]) ? $Folders[$i-1] : NULL;
        $Next = isset($Folders[$i+1]) ? $Folders[$i+1] : NULL;
        $IsSelected = $Folders[$i]->Id() == $SelectedFolder->Id();

        Folders_FolderDisplayUI::PrintFolder($ResourceFolderId, $Folders[$i], $Previous, $Next, $IsSelected);
    }
}

# ----- MAIN -----------------------------------------------------------------

global $ResourceFolder;
global $SelectedFolder;
global $Folders;
global $HasFolders;

PageTitle("Manage Folders");

# make sure the user is logged in
if (!CheckAuthorization()) return;

$FolderFactory = new Folders_FolderFactory($User->Id());
$ResourceFolder = $FolderFactory->GetResourceFolder();
$SelectedFolder = $FolderFactory->GetSelectedFolder();

# these should come after fetching the selected folder since a folder might be
# created by the FolderFactory::GetSelectedFolder method
$FolderIds = $ResourceFolder->GetItemIds();
$Folders = array();
$HasFolders = count($FolderIds);

# transform folder IDs to objects
foreach ($FolderIds as $FolderId)
{
    $Folders[$FolderId] = new Folders_Folder($FolderId);
}
