<?PHP
#
#   FILE:  TextFormField.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

  /**
   * Generator for text input fields
   * \nosubgrouping
   */

class TextFormField extends FormField {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization */
    /*@{*/

    /**
     * Object Constructor.
     * @param string $Name internal name for this field, used in html id=
     * @param bool $IsRequired whether or not the field is required
     * @param string $Label display name for this field, shown to user
     * @param int $Length Length of the display box
     * @param int $MaxLength The maximum allowed entry size
     * @param callback $ValidFunc A function to check this field for valid input (OPTIONAL)
     * @param array $ValidMsgs An array of error messages which should correspond
     *    to the error codes issued by ValidFunc (OPTIONAL)
     */
    function TextFormField(
            $Name, $IsRequired, $Label, $Length, $MaxLength,
            $ValidFunc = NULL, $ValidMsgs = NULL)
    {
        $this->MyLength = $Length;
        $this->MyMaxLength = $MaxLength;

        $this->FormField($Name, $IsRequired, $Label, $ValidFunc, $ValidMsgs);
    }

    /*@}*/

    /** @name Accessors */
    /*@{*/

    /**
     * Get or set the display length for this field
     * @param int $NewVal (OPTIONAL)
     * @return The current length
     */
    function Length($NewVal = NULL) {  return $this->GetOrSet("MyLength", $NewVal);  }

    /**
     * Get or set the maximum input length for this field
     * @param int $NewVal (OPTIONAL)
     * @return The current max input length
     */
    function MaxLength($NewVal = NULL) {  return $this->GetOrSet("MyMaxLength", $NewVal);  }

    /*@}*/

    /** @name Display */
    /*@{*/

    /**
     * Generate HTML for this object
     * @param bool $DisplayErrorIndicator (OPTIONAL)
     */
    function PrintInput($DisplayErrorIndicator = FALSE)
    {
        print("<input type=\"".
                    # (hack to support PasswordFormField object as well)
                    (method_exists($this, "PasswordFormField") ? "password" : "text")
                    ."\""
                ." name=\"".$this->MyName."\""
                ." value=\"".htmlspecialchars($this->MyValue)."\""
                ." size=\"".$this->MyLength."\""
                ." maxlength=\"".$this->MyMaxLength."\""
                .($DisplayErrorIndicator ? " style=\"background-color: #FFEEEE;\"" : "")
                ." />");
    }

    /*@}*/

    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $MyLength;
    private $MyMaxLength;
}


?>
