<?PHP
/**
* Display Recent Searches HTML -- called by MySearchesPlugin
* @param array $Searches of search arrays, the searches to display;
* Each search array contains string SearchURL -- full URL to reach
* the search execution, and string SearchName for use in the a tag
* for linking to the search.
* @return Returns the Recent Searches HTML as a string.
*/
function PrintRecentSearchesSidebarBlock($Searches)
{
?>
      <!-- BEGIN RECENT SEARCHES DISPLAY -->
      <div class="cw-section cw-section-simple cw-html5-section">
          <div class="cw-section-header cw-html5-header">
              <b>Recent Searches</b>
          </div>
          <div class="cw-section-body">
              <ul class="cw-list cw-list-noindent cw-list-dotlist">
              <?PHP
               foreach ($Searches as $Search)
               {?>
                  <li><a href="<?PHP print $Search["SearchURL"];?>">
                      <?PHP print $Search["SearchName"];?></a>
                  </li>
          <?PHP
               }?>
              </ul>
          </div>
      </div>
      <!-- END RECENT SEARCHES DISPLAY -->
<?PHP
}
