<?PHP
#
#   FILE:  BlogReports.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# Helper function to deal with data summary arrays:
function CreateOrIncrement(&$Array, $Key)
{
    if (!isset($Array[$Key]))
        $Array[$Key] = 1;
    else
        $Array[$Key]++;
}


# ----- MAIN -----------------------------------------------------------------

PageTitle("Blog Usage Metrics");

# make sure user has sufficient permission to view report
if (!CheckAuthorization(PRIV_COLLECTIONADMIN)) {  return;  }

# Check to be sure that the CalendarEvents plugin is actually enabled before doing other things.
if (!$GLOBALS["G_PluginManager"]->PluginEnabled("Blog") ){
    CheckAuthorization(-1);
    return;
}


# Grab ahold of the relevant metrics objects:
$Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
$Reporter = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsReporter");

$Blog = $GLOBALS["G_PluginManager"]->GetPlugin("Blog");

$Now = time();

$Past = array(
    "Week"  => $Now -   7 * 86400,
    "Month" => $Now -  30 * 86400,
    "Year" => $Now - 365 * 86400
);

$H_WeekAgo  = date('Y-m-d', $Past["Week"]);
$H_MonthAgo = date('Y-m-d', $Past["Month"]);
$H_YearAgo  = date('Y-m-d', $Past["Year"]);

#
# Blog Views per day
#
$ViewsPerDay = array();
$H_ViewData = array(
    "Week" => array(),
    "Month" => array(),
    "Year" => array() );

foreach ($Recorder->GetEventData(
             "Blog", "ViewEntry",
             NULL, NULL, NULL,
             NULL, NULL, $Reporter->ConfigSetting("PrivsToExcludeFromCounts"),
             0, NULL) as $Event)
{
    $TS = strtotime( date( 'Y-m-d', strtotime($Event["EventDate"])));

    if (!isset($ViewsPerDay[$TS]))
        $ViewsPerDay[$TS] = array(1);
    else
        $ViewsPerDay[$TS][0] += 1;

    foreach (array("Week","Month","Year") as $Period)
    {
        if ($Past[$Period] < $TS)
            CreateOrIncrement($H_ViewData[$Period], $Event["DataOne"]);
    }
}

$H_ViewsPerDay = new Graph(Graph::TYPE_DATE_BAR, $ViewsPerDay);
$H_ViewsPerDay->XLabel("Date");
$H_ViewsPerDay->YLabel("Blog Views");

#
# Blog shares per day
#

# Get a list of all the Resources that are also events
# Use that to filter the shares data

$BlogFactory = new ResourceFactory( $Blog->GetSchemaId() );

$PostIds = array();
foreach ($BlogFactory->GetItemIds() as $BlogId)
    $PostIds[ $BlogId ] = 1;

$SharesData = array();
$H_ShareData = array(
    "Week" => array(),
    "Month" => array(),
    "Year" => array() );

$ShareTypeMap = array(
    SocialMedia::SITE_EMAIL => 0,
    SocialMedia::SITE_FACEBOOK => 1,
    SocialMedia::SITE_TWITTER => 2,
    SocialMedia::SITE_LINKEDIN => 3,
    SocialMedia::SITE_GOOGLEPLUS => 4
    );

foreach ($Recorder->GetEventData(
             "SocialMedia", "ShareResource",
             NULL, NULL, NULL,
             NULL, NULL, $Reporter->ConfigSetting("PrivsToExcludeFromCounts"),
             0, NULL) as $Event)
{
    # Skip non-event shares:
    if (!isset($PostIds[ $Event["DataOne"] ] ))
        continue;

    $TS =  strtotime($Event["EventDate"]);

    $SharesData[$TS] = array(0, 0, 0, 0, 0);
    $SharesData[$TS][ $ShareTypeMap[$Event["DataTwo"] ] ] = 1;

    foreach (array("Week","Month","Year") as $Period)
    {
        if ($Past[$Period] < $TS)
            CreateOrIncrement( $H_ShareData[$Period], $Event["DataOne"]);
    }

}

$H_SharesPerDay = new Graph(Graph::TYPE_DATE_BAR, $SharesData );
$H_SharesPerDay->XLabel("Date");
$H_SharesPerDay->YLabel("Blog Shares");
$H_SharesPerDay->Legend( array("Email", "Facebook", "Twitter", "LinkedIn", "GooglePlus") );
$H_SharesPerDay->Scale(Graph::WEEKLY);

#
# Most viewed and shared blog posts
#

foreach (array("Week", "Month", "Year") as $Period)
{
    arsort($H_ViewData[$Period]);
    arsort($H_ShareData[$Period]);
}
