<?PHP
#
#   FILE:  Information.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Print the given subscriber list.
 * @param array $Subscribers subscriber list
 */
function PrintSubscribers(array $Subscribers)
{
    foreach ($Subscribers as $Email => $Info)
    {
        PrintSubscriber($Email, $Info);
    }
}

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

PageTitle("Mailing List Information");

$Statistics = $AF->SignalEvent("MAILMAN_GET_DEFAULT_LIST_STATISTICS");

# If we have subscriber metrics, make a plot of them:
if ( !is_null($GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder")) )
{
    $Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
    $Data = $Recorder->GetEventData("Mailman", "NumberOfSubscribers",
                                    date("Y-m-d", strtotime('-24 months')) );

    $GraphData = array();
    foreach ($Data as $Item)
    {
        if ($Item["DataTwo"] > 0 )
            $GraphData[ strtotime( $Item["EventDate"] ) ] = array(
                $Item["DataTwo"] );
    }

    global $H_Graph;
    $H_Graph = new Graph(Graph::TYPE_DATE, $GraphData );

    $H_Graph->XLabel("Date");
    $H_Graph->YLabel( $Statistics["MailingListLabel"]." Subscribers" );
}
