<?PHP
#
#   FILE:  AddItem.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $AF;

# check authorization and setup HTML suppression and page redirection
if (!Folders_Common::ApiPageCompletion("P_Folders_ManageFolders")) return;

$FolderId = GetArrayValue($_GET, "FolderId");
$ItemId = GetArrayValue($_GET, "ItemId");

# try to set the ideal jump to page, otherwise use the less than ideal default
if (isset($_SERVER["HTTP_REFERER"]))
{
    $AF->SetJumpToPage($_SERVER["HTTP_REFERER"]);
}
else if (GetArrayValue($_GET, "ReturnTo", FALSE))
{
    $AF->SetJumpToPage(urldecode($_GET["ReturnTo"]));
}

# get the currently selected folder if no folder ID is given
if (!strlen($FolderId))
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $FolderId = $FolderFactory->GetSelectedFolder()->Id();
}

# can't do anything without a valid item ID
if (!strlen($ItemId))
{
    return;
}

try
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $Folder = new Folders_Folder($FolderId);
    $Resource = new Resource($ItemId);

    # add item only if the resource folder contains this folder, which implies
    # that the user owns the folder and it's a valid folder of resources
    if ($ResourceFolder->ContainsItem($Folder->Id()))
    {
        if ($Resource->Status() === 1)
        {
            $Folder->AppendItem($Resource->Id());
        }
    }
} catch (Exception $Exception) {}
