<?PHP
#
#   FILE:  EditSysConfigAdvancedComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

# get the necessary global variables
global $AF, $G_SysConfig;

# prepare an error list in case we have to return to the previous page
$H_ErrorMessages = new ErrorList();

# if save changes was requested
if ($_POST["Submit"] != "Cancel")
{
    # save new default character coding setting
    $G_SysConfig->DefaultCharacterSet($_POST["F_DefaultCharacterSet"]);

    # save the number of resources used for generating search facets setting
    $F_NumResourcesForSearchFacets = intval($_POST["F_NumResourcesForSearchFacets"]);
    $G_SysConfig->NumResourcesForSearchFacets(
            max($G_SysConfig->DefaultRecordsPerPage(),
            $F_NumResourcesForSearchFacets) );

    # save new logging level
    $AF->LoggingLevel($_POST["F_LoggingLevel"]);

    # save the new maximum execution time
    if (isset($_POST["F_MaxExecTime"]))
    {
        $AF->MaxExecutionTime(max(5, $_POST["F_MaxExecTime"]));
    }

    # save the new template location cache expiration setting
    if (isset($_POST["F_TemplateCacheExpiration"]))
    {
        $AF->TemplateLocationCacheExpirationInterval(
                max(0, $_POST["F_TemplateCacheExpiration"]));
    }

    # save the new object location cache expiration
    if (isset($_POST["F_ObjectCacheExpiration"]))
    {
        $AF->ObjectLocationCacheExpirationInterval(
                max(0, $_POST["F_ObjectCacheExpiration"]));
    }

    # save the new use minimized javascript setting
    $G_SysConfig->Value("UseMinimizedJavascript",
            GetArrayValue($_POST, "F_UseMinimizedJavascript"), 0);

    # save the logging of slow page loads setting
    $AF->LogSlowPageLoads(
            GetArrayValue($_POST, "F_LogSlowPageLoads", 0));

    # save the slow page threshold setting
    $AF->SlowPageLoadThreshold(
            GetArrayValue($_POST, "F_SlowPageLoadThreshold", 10));

    # save the logging of high memory usage setting
    $AF->LogHighMemoryUsage(
            GetArrayValue($_POST, "F_LogHighMemoryUsage", 0));

    # save the high memory usage threshold setting
    $AF->HighMemoryUsageThreshold(
            GetArrayValue($_POST, "F_HighMemoryUsageThreshold", 90));

    # save the new prefer HTTP_HOST setting
    $G_SysConfig->PreferHttpHost(isset($_POST["F_PreferHttpHost"]));

    # save the new root URL override setting
    if (isset($_POST["F_RootUrlOverride"]))
    {
        $G_SysConfig->RootUrlOverride($_POST["F_RootUrlOverride"]);
    }

    # save the email line ending setting
    if (isset($_POST["F_EmailLineEnding"]))
    {
        $G_SysConfig->EmailLineEnding($_POST["F_EmailLineEnding"]);
    }

    # set up to test new email delivery settings
    if (isset($_POST["F_MailingMethod"])) {
            Email::DeliveryMethod($_POST["F_MailingMethod"]);  }
    if (isset($_POST["F_SmtpServer"])) {
            Email::Server($_POST["F_SmtpServer"]);  }
    if (isset($_POST["F_SmtpPort"])) {
            Email::Port($_POST["F_SmtpPort"]);  }
    Email::UseAuthentication(isset($_POST["F_SmtpUseAuthentication"]));
    if (isset($_POST["F_SmtpUserName"]))
            {  Email::UserName($_POST["F_SmtpUserName"]);  }
    if (isset($_POST["F_SmtpPassword"])
            && $_POST["F_SmtpPassword"] != SystemConfiguration::UNCHANGED_VALUE)
            {  Email::Password($_POST["F_SmtpPassword"]);  }

    # if email delivery settings tested out okay
    if (Email::DeliverySettingsOkay())
    {
        # save new delivery settings
        $G_SysConfig->Value("EmailDeliverySettings", Email::DeliverySettings());
    }
    else
    {
        # set error message to be displayed
        $Errs = Email::DeliverySettingErrors();
        if (in_array("UseAuthentication", $Errs)
                || in_array("UserName", $Errs)
                || in_array("Password", $Errs))
        {
            $Msg = "Unable to connect with the specified <b>SMTP User Name</b>"
                    . " and <b>SMTP Password</b>. Please check that these"
                    . " values are correct to connect to <i>"
                    . $_POST["F_SmtpServer"] . "</i>.";
        }
        elseif (in_array("Server", $Errs)
                || in_array("Port", $Errs))
        {
            $Msg = "An error was found with the <b>SMTP Server</b> or"
                    ." <b>SMTP Port</b> number.  Please check that these values"
                    ." are correct.";
        }
        elseif (in_array("TLS", $Errs))
        {
            $Msg = "An error was encountered trying to make a TLS connection to"
                    ." the specified server for SMTP.  Please check the server"
                    ." and port values to make sure they are correct.";
        }
        else
        {
            $Msg = "An unknown error was encountered while trying to verify the"
                    ." <i>Mailing</i> settings.";
        }
        $H_ErrorMessages->AddMessage($Msg);

        # pass new settings back to be corrected
        if (isset($_POST["F_MailingMethod"]))
                $_SESSION["F_MailingMethod"] = $_POST["F_MailingMethod"];
        if (isset($_POST["F_SmtpServer"]))
                $_SESSION["F_SmtpServer"] = $_POST["F_SmtpServer"];
        if (isset($_POST["F_SmtpPort"]))
                $_SESSION["F_SmtpPort"] = $_POST["F_SmtpPort"];
        if (isset($_POST["F_SmtpUseAuthentication"]))
                $_SESSION["F_SmtpUseAuthentication"] = $_POST["F_SmtpUseAuthentication"];
        if (isset($_POST["F_SmtpUserName"]))
                $_SESSION["F_SmtpUserName"] = $_POST["F_SmtpUserName"];
        if (isset($_POST["F_SmtpPassword"]))
                $_SESSION["F_SmtpPassword"] = $_POST["F_SmtpPassword"];
    }
}

# if errors were found
if (isset($H_ErrorMessages) && $H_ErrorMessages->HasErrors())
{
    # return to editing page with error messages
    $_SESSION["H_ErrorMessages"] = serialize($H_ErrorMessages);
    $AF->SetJumpToPage("EditSysConfigAdvanced");
}
else
{
    # go to sys admin page
    $AF->SetJumpToPage("SysAdmin");
}
